/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import javax.swing.text.Document;

public class MultiColumnRegexFilter {
    private static final Logger logger = Logger.getLogger(MultiColumnRegexFilter.class.getName());
    private final Consumer<? super RowFilter<TableModel, Integer>> filterConsumer;
    private final List<JTextField> textFields;
    private boolean ignoringCase;

    public MultiColumnRegexFilter(Consumer<? super RowFilter<TableModel, Integer>> filterConsumer) {
        this.filterConsumer = Objects.requireNonNull(filterConsumer, "The filterConsumer may not be null");
        this.textFields = new ArrayList<JTextField>();
        this.ignoringCase = true;
    }

    public void clearAll() {
        for (int i = 0; i < this.textFields.size(); ++i) {
            JTextField textField = this.textFields.get(i);
            if (textField == null) continue;
            textField.setText("");
        }
    }

    public void setIgnoringCase(boolean ignoringCase) {
        this.ignoringCase = ignoringCase;
        this.updateFilter();
    }

    public JTextField createFilterTextField(int columnIndex) {
        while (this.textFields.size() - 1 < columnIndex) {
            this.textFields.add(null);
        }
        JTextField textField = new JTextField();
        this.textFields.set(columnIndex, textField);
        Document document = textField.getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                MultiColumnRegexFilter.this.updateFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                MultiColumnRegexFilter.this.updateFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MultiColumnRegexFilter.this.updateFilter();
            }
        });
        return textField;
    }

    public void removeFilterTextField(int columnIndex) {
        this.textFields.remove(columnIndex);
    }

    private void updateFilter() {
        ArrayList<RowFilter<TableModel, Integer>> regexFilters = new ArrayList<RowFilter<TableModel, Integer>>();
        for (int i = 0; i < this.textFields.size(); ++i) {
            String regex;
            RowFilter<TableModel, Integer> regexFilter;
            JTextField textField = this.textFields.get(i);
            if (textField == null || (regexFilter = this.createRegexFilter(regex = textField.getText(), i)) == null) continue;
            regexFilters.add(regexFilter);
        }
        if (regexFilters.isEmpty()) {
            this.filterConsumer.accept(null);
        } else {
            RowFilter rowFilter = RowFilter.andFilter(regexFilters);
            this.filterConsumer.accept(rowFilter);
        }
    }

    private RowFilter<TableModel, Integer> createRegexFilter(String regex, int columnIndex) {
        try {
            String finalRegex = regex;
            if (this.ignoringCase) {
                finalRegex = "(?i)" + regex;
            }
            RowFilter<TableModel, Integer> rowFilter = RowFilter.regexFilter(finalRegex, columnIndex);
            return rowFilter;
        }
        catch (PatternSyntaxException e) {
            logger.warning(e.getMessage());
            return null;
        }
    }
}

