/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.table;

import de.javagl.common.ui.JTables;
import de.javagl.common.ui.LocationBasedAction;
import de.javagl.common.ui.list.ListSelectionModels;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JTable;

class RemoveEqualFromSelectionAction
extends LocationBasedAction {
    private static final long serialVersionUID = 4834084711475530242L;
    private JTable table;
    private int row;
    private int col;

    RemoveEqualFromSelectionAction() {
        this.putValue("Name", "RemoveEqualFromSelectionAction");
        this.putValue("ShortDescription", "Remove all rows where the value is equal to the clicked value from the selection");
        this.putValue("MnemonicKey", 82);
    }

    @Override
    protected void prepareShow(Component component, int x, int y) {
        this.table = (JTable)component;
        Point p = new Point(x, y);
        this.row = this.table.rowAtPoint(p);
        this.col = this.table.columnAtPoint(p);
        if (this.row != -1 && this.col != -1) {
            String columnName = this.table.getColumnName(this.col);
            Object value = this.table.getValueAt(this.row, this.col);
            this.putValue("Name", "Remove from selection all where " + columnName + " is \"" + value + "\"");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Integer> selectedRows = JTables.computeRowsWithEqualValue(this.table, this.row, this.col);
        ListSelectionModels.removeFromSelection(this.table.getSelectionModel(), selectedRows);
    }
}

