/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.table.renderer;

import java.awt.Color;
import java.awt.Component;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class BackgroundColorTableCellRenderer
implements TableCellRenderer {
    private final TableCellRenderer delegate;
    private final Function<Object, ? extends Color> colorFunction;

    BackgroundColorTableCellRenderer(TableCellRenderer delegate, Function<Object, ? extends Color> colorFunction) {
        this.delegate = Objects.requireNonNull(delegate, "The delegate may not be null");
        this.colorFunction = Objects.requireNonNull(colorFunction, "The colorFunction may not be null");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent c;
        Component component = this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Color color = this.colorFunction.apply(value);
        if (color != null) {
            component.setBackground(color);
            Color foregroundColor = BackgroundColorTableCellRenderer.computeContrastingColor(color.getRGB());
            component.setForeground(foregroundColor);
        } else {
            component.setBackground(table.getBackground());
            component.setForeground(table.getForeground());
        }
        if (isSelected) {
            c = (JComponent)component;
            c.setBorder(BorderFactory.createLineBorder(table.getSelectionBackground(), 2));
        } else {
            c = (JComponent)component;
            c.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        return component;
    }

    private static Color computeContrastingColor(int argb) {
        if (BackgroundColorTableCellRenderer.computeLuminance(argb) > 0.179) {
            return Color.BLACK;
        }
        return Color.WHITE;
    }

    private static double computeLuminance(int argb) {
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        double nr = Math.pow((double)r / 255.0, 2.2);
        double ng = Math.pow((double)g / 255.0, 2.2);
        double nb = Math.pow((double)b / 255.0, 2.2);
        double y = 0.2126 * nr + 0.7151 * ng + 0.0721 * nb;
        return y;
    }
}

