/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.table.renderer;

import de.javagl.common.ui.table.renderer.BackgroundColorTableCellRenderer;
import de.javagl.common.ui.table.renderer.NumberTableCellRenderer;
import java.awt.Color;
import java.util.Objects;
import java.util.function.DoubleFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;

public class NumberBackgroundColorTableCellRenderer
extends BackgroundColorTableCellRenderer {
    public NumberBackgroundColorTableCellRenderer(double min, double max, DoubleFunction<? extends Color> colorFunction, Function<? super Number, String> numberFormatter) {
        super(new NumberTableCellRenderer(numberFormatter), NumberBackgroundColorTableCellRenderer.createCellColorFunction(min, max, colorFunction));
    }

    private static Function<Object, ? extends Color> createCellColorFunction(double min, double max, DoubleFunction<? extends Color> colorFunction) {
        Objects.requireNonNull(colorFunction, "The colorFunction may not be null");
        DoubleUnaryOperator mapping = value -> (value - min) / (max - min);
        Function<Object, Color> cellColorFunction = object -> {
            if (object instanceof Number) {
                Number number = (Number)object;
                double normalized = mapping.applyAsDouble(number.doubleValue());
                Color color = (Color)colorFunction.apply(normalized);
                return color;
            }
            return null;
        };
        return cellColorFunction;
    }
}

