/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.table.renderer;

import java.awt.Component;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class NumberTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -474975707473940777L;
    private final Function<? super Number, String> numberFormatter;

    NumberTableCellRenderer(Function<? super Number, String> numberFormatter) {
        this.numberFormatter = Objects.requireNonNull(numberFormatter, "The numberFormatter may not be null");
        this.setHorizontalAlignment(4);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null) {
            this.setText("");
        } else if (value instanceof Number) {
            Number number = (Number)value;
            String s = this.numberFormatter.apply(number);
            this.setText(s);
        } else {
            this.setText(String.valueOf(value));
        }
        return this;
    }
}

