/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.table.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public final class SortOrderTableHeaderCellRenderer
implements TableCellRenderer {
    private final TableCellRenderer delegate;

    public SortOrderTableHeaderCellRenderer(TableCellRenderer delegate) {
        this.delegate = delegate;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component delegateComponent = this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (delegateComponent instanceof JLabel) {
            int sortPriority;
            JLabel delegateLabel = (JLabel)delegateComponent;
            delegateLabel.setIcon(null);
            SortOrder sortOrder = SortOrderTableHeaderCellRenderer.getSortOrder(table, column);
            if (sortOrder != null && (sortPriority = SortOrderTableHeaderCellRenderer.getSortPriority(table, column)) >= 0) {
                delegateLabel.setIcon(this.createIcon(sortOrder, sortPriority));
            }
        }
        return delegateComponent;
    }

    private Icon createIcon(SortOrder sortOrder, int sortPriority) {
        final Color color = UIManager.getColor("controlDkShadow");
        int width = 12;
        int height = 12;
        int sizeX = Math.max(2, 12 - sortPriority * 2);
        int sizeY = Math.max(2, 12 - sortPriority * 2);
        int space = (12 - sizeY) / 2;
        final Shape shape = sortOrder == SortOrder.ASCENDING ? SortOrderTableHeaderCellRenderer.createArrowShape(sizeX, space, 12 - space) : SortOrderTableHeaderCellRenderer.createArrowShape(sizeX, 12 - space, space);
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics gr, int x, int y) {
                Graphics2D g = (Graphics2D)gr;
                AffineTransform oldAT = g.getTransform();
                g.translate(x, y);
                g.setColor(color);
                g.fill(shape);
                g.setTransform(oldAT);
            }

            @Override
            public int getIconWidth() {
                return 12;
            }

            @Override
            public int getIconHeight() {
                return 12;
            }
        };
    }

    private static Shape createArrowShape(int w, int y0, int y1) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(0.0, y0);
        if ((w & 1) == 0) {
            ((Path2D)path).lineTo(w >> 1, y1);
        } else {
            int c = w >> 1;
            ((Path2D)path).lineTo(c, y1);
            ((Path2D)path).lineTo(c + 1, y1);
        }
        ((Path2D)path).lineTo(w, y0);
        path.closePath();
        return path;
    }

    private static SortOrder getSortOrder(JTable table, int column) {
        List<RowSorter.SortKey> sortKeys = table.getRowSorter().getSortKeys();
        for (int i = 0; i < sortKeys.size(); ++i) {
            RowSorter.SortKey sortKey = sortKeys.get(i);
            if (sortKey.getColumn() != table.convertColumnIndexToModel(column)) continue;
            return sortKey.getSortOrder();
        }
        return null;
    }

    private static int getSortPriority(JTable table, int column) {
        List<RowSorter.SortKey> sortKeys = table.getRowSorter().getSortKeys();
        for (int i = 0; i < sortKeys.size(); ++i) {
            RowSorter.SortKey sortKey = sortKeys.get(i);
            if (sortKey.getColumn() != table.convertColumnIndexToModel(column)) continue;
            return i;
        }
        return -1;
    }
}

