/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.text;

import de.javagl.common.ui.text.StringUtils;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

class JTextComponents {
    private static final Logger logger = Logger.getLogger(JTextComponents.class.getName());

    static Point findNext(String text, String query, int startIndex, boolean ignoreCase) {
        int offset = StringUtils.indexOf(text, query, startIndex, ignoreCase);
        int length = query.length();
        if (offset != -1) {
            return new Point(offset, offset + length);
        }
        return null;
    }

    static Point findPrevious(String text, String query, int startIndex, boolean ignoreCase) {
        int offset = StringUtils.lastIndexOf(text, query, startIndex, ignoreCase);
        int length = query.length();
        if (offset != -1) {
            return new Point(offset, offset + length);
        }
        return null;
    }

    static List<Point> find(String text, String query, boolean ignoreCase) {
        ArrayList<Point> appearances = new ArrayList<Point>();
        int offset = StringUtils.indexOf(text, query, 0, ignoreCase);
        int length = query.length();
        while (offset != -1) {
            appearances.add(new Point(offset, offset + length));
            offset = StringUtils.indexOf(text, query, offset + 1, ignoreCase);
        }
        return appearances;
    }

    static Map<Point, Object> addHighlights(JTextComponent textComponent, Iterable<? extends Point> appearances, Color color) {
        DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(color);
        Highlighter highlighter = textComponent.getHighlighter();
        LinkedHashMap<Point, Object> highlights = new LinkedHashMap<Point, Object>();
        for (Point point : appearances) {
            try {
                Object highlight = highlighter.addHighlight(point.x, point.y, painter);
                highlights.put(point, highlight);
            }
            catch (BadLocationException e) {
                logger.severe(e.toString());
            }
        }
        return highlights;
    }

    static void removeHighlights(JTextComponent textComponent, Iterable<?> highlights) {
        Highlighter highlighter = textComponent.getHighlighter();
        for (Object highlight : highlights) {
            highlighter.removeHighlight(highlight);
        }
    }

    private JTextComponents() {
    }
}

