/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.text;

import de.javagl.common.ui.text.Actions;
import de.javagl.common.ui.text.SearchableTextComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicArrowButton;

class SearchPanel
extends JPanel {
    private static final long serialVersionUID = -875498007982382336L;
    private final JTextField textField;
    private final JCheckBox caseSensitiveCheckBox;
    private final JLabel messageLabel;

    SearchPanel(final SearchableTextComponent owner) {
        super(new BorderLayout());
        Objects.requireNonNull(owner, "The owner may not be null");
        JPanel mainPanel = new JPanel(new GridLayout(2, 1));
        JPanel topPanel = new JPanel(new BorderLayout());
        this.textField = new JTextField();
        topPanel.add((Component)this.textField, "Center");
        this.caseSensitiveCheckBox = new JCheckBox("Case sensitive");
        this.caseSensitiveCheckBox.addActionListener(e -> owner.updateSearchResults());
        topPanel.add((Component)this.caseSensitiveCheckBox, "East");
        mainPanel.add(topPanel);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        this.messageLabel = new JLabel(" ");
        bottomPanel.add((Component)this.messageLabel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 0, 0));
        BasicArrowButton prevButton = new BasicArrowButton(1);
        prevButton.addActionListener(e -> owner.doFindPrevious());
        buttonPanel.add(prevButton);
        BasicArrowButton nextButton = new BasicArrowButton(5);
        nextButton.addActionListener(e -> owner.doFindNext());
        buttonPanel.add(nextButton);
        bottomPanel.add((Component)buttonPanel, "East");
        mainPanel.add(bottomPanel);
        this.add((Component)mainPanel, "Center");
        KeyStroke hideKeyStroke = KeyStroke.getKeyStroke(27, 0);
        this.getInputMap(1).put(hideKeyStroke, "SearchPanel.doHide");
        this.getActionMap().put("SearchPanel.doHide", Actions.create(() -> owner.setSearchPanelVisible(false)));
        KeyStroke findNextKeyStroke = KeyStroke.getKeyStroke(114, 0);
        this.textField.getInputMap(0).put(findNextKeyStroke, "SearchPanel.doFindNext");
        this.textField.getActionMap().put("SearchPanel.doFindNext", Actions.create(() -> owner.doFindNext()));
        KeyStroke findPreviousKeyStroke = KeyStroke.getKeyStroke(114, 64);
        this.textField.getInputMap(0).put(findPreviousKeyStroke, "SearchPanel.doFindPrevious");
        this.textField.getActionMap().put("SearchPanel.doFindPrevious", Actions.create(() -> owner.doFindPrevious()));
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                owner.updateSearchResults();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                owner.updateSearchResults();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                owner.updateSearchResults();
            }
        });
    }

    boolean isCaseSensitive() {
        return this.caseSensitiveCheckBox.isSelected();
    }

    String getQuery() {
        return this.textField.getText();
    }

    void setQuery(String query) {
        this.textField.setText(query);
    }

    void requestFocusForTextField() {
        this.textField.requestFocus();
    }

    void setMessage(String message) {
        this.messageLabel.setText(message);
    }
}

