/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.text;

import de.javagl.common.ui.text.Actions;
import de.javagl.common.ui.text.JTextComponents;
import de.javagl.common.ui.text.SearchPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class SearchableTextComponent
extends JPanel {
    private static final Logger logger = Logger.getLogger(SearchableTextComponent.class.getName());
    private static final long serialVersionUID = -2539643515896947981L;
    private final JTextComponent textComponent;
    private final SearchPanel searchPanel;
    private boolean searchPanelVisible;
    private final Map<Point, Object> highlights;
    private final Color highlightColor = new Color(128, 255, 128, 64);

    public SearchableTextComponent(JTextComponent textComponent) {
        super(new BorderLayout());
        this.textComponent = Objects.requireNonNull(textComponent, "The textComponent may not be null");
        this.highlights = new LinkedHashMap<Point, Object>();
        JScrollPane scrollPane = new JScrollPane(textComponent);
        this.add((Component)scrollPane, "Center");
        this.searchPanel = new SearchPanel(this);
        KeyStroke doSearchKeyStroke = KeyStroke.getKeyStroke(70, 128);
        textComponent.getInputMap().put(doSearchKeyStroke, "SearchableTextComponent.doSearch");
        textComponent.getActionMap().put("SearchableTextComponent.doSearch", Actions.create(this::doSearch));
        KeyStroke findNextKeyStroke = KeyStroke.getKeyStroke(114, 0);
        textComponent.getInputMap(0).put(findNextKeyStroke, "SearchableTextComponent.doFindNext");
        textComponent.getActionMap().put("SearchableTextComponent.doFindNext", Actions.create(this::doFindNext));
        KeyStroke findPreviousKeyStroke = KeyStroke.getKeyStroke(114, 64);
        textComponent.getInputMap(0).put(findPreviousKeyStroke, "SearchableTextComponent.doFindPrevious");
        textComponent.getActionMap().put("SearchableTextComponent.doFindPrevious", Actions.create(this::doFindPrevious));
        textComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchableTextComponent.this.updateSearchResults(false);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchableTextComponent.this.updateSearchResults(false);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchableTextComponent.this.updateSearchResults(false);
            }
        });
    }

    private void doSearch() {
        this.setSearchPanelVisible(true);
        String selectedText = this.textComponent.getSelectedText();
        if (selectedText != null) {
            this.searchPanel.setQuery(selectedText);
        }
        this.searchPanel.requestFocusForTextField();
    }

    void setSearchPanelVisible(boolean b) {
        if (!this.searchPanelVisible && b) {
            this.add((Component)this.searchPanel, "North");
            this.revalidate();
        } else if (this.searchPanelVisible && !b) {
            this.remove(this.searchPanel);
            this.revalidate();
        }
        this.searchPanelVisible = b;
    }

    void doFindNext() {
        int textLength;
        String query = this.searchPanel.getQuery();
        if (query.isEmpty()) {
            return;
        }
        String text = this.getDocumentText();
        boolean ignoreCase = !this.searchPanel.isCaseSensitive();
        int caretPosition = this.textComponent.getCaretPosition();
        int newCaretPosition = (caretPosition + 1) % (textLength = text.length());
        Point match = JTextComponents.findNext(text, query, newCaretPosition, ignoreCase);
        if (match == null) {
            match = JTextComponents.findNext(text, query, 0, ignoreCase);
        }
        this.handleMatch(match);
    }

    void doFindPrevious() {
        Point match;
        String query = this.searchPanel.getQuery();
        if (query.isEmpty()) {
            return;
        }
        String text = this.getDocumentText();
        boolean ignoreCase = !this.searchPanel.isCaseSensitive();
        int caretPosition = this.textComponent.getCaretPosition();
        int textLength = text.length();
        int newCaretPosition = caretPosition - 1;
        if (newCaretPosition < 0) {
            newCaretPosition += textLength;
        }
        if ((match = JTextComponents.findPrevious(text, query, newCaretPosition, ignoreCase)) == null) {
            match = JTextComponents.findPrevious(text, query, textLength - 1, ignoreCase);
        }
        this.handleMatch(match);
    }

    private String getDocumentText() {
        try {
            Document document = this.textComponent.getDocument();
            String text = document.getText(0, document.getLength());
            return text;
        }
        catch (BadLocationException e) {
            logger.warning(e.toString());
            return this.textComponent.getText();
        }
    }

    void updateSearchResults() {
        this.updateSearchResults(true);
    }

    void updateSearchResults(boolean selectFirstMatch) {
        this.clearHighlights();
        this.searchPanel.setMessage("");
        String query = this.searchPanel.getQuery();
        if (query.isEmpty()) {
            this.handleMatch(null);
            return;
        }
        String text = this.getDocumentText();
        boolean ignoreCase = !this.searchPanel.isCaseSensitive();
        List<Point> appearances = JTextComponents.find(text, query, ignoreCase);
        this.addHighlights(appearances, this.highlightColor);
        int caretPosition = this.textComponent.getCaretPosition();
        Point match = JTextComponents.findNext(text, query, caretPosition, ignoreCase);
        if (match == null) {
            match = JTextComponents.findNext(text, query, 0, ignoreCase);
        }
        if (selectFirstMatch) {
            this.handleMatch(match);
        } else {
            this.handleMatch(null);
        }
        if (appearances.isEmpty()) {
            this.searchPanel.setMessage("Not found");
        } else {
            this.searchPanel.setMessage("Found " + appearances.size() + " times");
        }
    }

    private void handleMatch(Point match) {
        if (match == null) {
            int caretPosition = this.textComponent.getCaretPosition();
            Document document = this.textComponent.getDocument();
            caretPosition = Math.max(0, Math.min(document.getLength(), caretPosition));
            this.textComponent.setCaretPosition(caretPosition);
            this.textComponent.moveCaretPosition(caretPosition);
            this.textComponent.getCaret().setSelectionVisible(false);
        } else {
            this.textComponent.setCaretPosition(match.y);
            this.textComponent.moveCaretPosition(match.x);
            this.textComponent.getCaret().setSelectionVisible(true);
        }
    }

    private void addHighlights(Collection<? extends Point> points, Color color) {
        this.removeHighlights(points);
        Map<Point, Object> newHighlights = JTextComponents.addHighlights(this.textComponent, points, color);
        this.highlights.putAll(newHighlights);
    }

    private void removeHighlights(Collection<? extends Point> points) {
        LinkedHashSet<Object> highlightsToRemove = new LinkedHashSet<Object>();
        for (Point point : points) {
            Object oldHighlight = this.highlights.remove(point);
            if (oldHighlight == null) continue;
            highlightsToRemove.add(oldHighlight);
        }
        JTextComponents.removeHighlights(this.textComponent, highlightsToRemove);
    }

    private void clearHighlights() {
        this.removeHighlights(new ArrayList<Point>(this.highlights.keySet()));
    }
}

