/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.text;

import java.util.function.IntBinaryOperator;

class StringUtils {
    private static final IntBinaryOperator IGNORING_CASE = (c0, c1) -> {
        char u1;
        char u0 = Character.toUpperCase((char)c0);
        if (u0 == (u1 = Character.toUpperCase((char)c1))) {
            return 0;
        }
        if (Character.toLowerCase(u0) == Character.toLowerCase(u1)) {
            return 0;
        }
        return 1;
    };

    static int indexOf(String source, String target, int startIndex, boolean ignoreCase) {
        if (ignoreCase) {
            return StringUtils.indexOf(source, target, startIndex, IGNORING_CASE);
        }
        return StringUtils.indexOf(source, target, startIndex, (c0, c1) -> Integer.compare(c0, c1));
    }

    private static int indexOf(String source, String target, int startIndex, IntBinaryOperator comparator) {
        return StringUtils.indexOf(source, 0, source.length(), target, 0, target.length(), startIndex, comparator);
    }

    private static int indexOf(String source, int sourceOffset, int sourceCount, String target, int targetOffset, int targetCount, int startIndex, IntBinaryOperator comparator) {
        int fromIndex = startIndex;
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target.charAt(targetOffset);
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (comparator.applyAsInt(source.charAt(i), first) != 0) {
                while (++i <= max && comparator.applyAsInt(source.charAt(i), first) != 0) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && comparator.applyAsInt(source.charAt(j), target.charAt(k)) == 0) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    static int lastIndexOf(String source, String target, int startIndex, boolean ignoreCase) {
        if (ignoreCase) {
            return StringUtils.lastIndexOf(source, target, startIndex, IGNORING_CASE);
        }
        return StringUtils.lastIndexOf(source, target, startIndex, (c0, c1) -> Integer.compare(c0, c1));
    }

    private static int lastIndexOf(String source, String target, int startIndex, IntBinaryOperator comparator) {
        return StringUtils.lastIndexOf(source, 0, source.length(), target, 0, target.length(), startIndex, comparator);
    }

    static int lastIndexOf(String source, int sourceOffset, int sourceCount, String target, int targetOffset, int targetCount, int startIndex, IntBinaryOperator comparator) {
        int start;
        int fromIndex = startIndex;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        char strLastChar = target.charAt(strLastIndex);
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && comparator.applyAsInt(source.charAt(i), strLastChar) != 0) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (comparator.applyAsInt(source.charAt(j--), target.charAt(k--)) == 0) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    private StringUtils() {
    }
}

