/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.text;

import de.javagl.common.ui.text.Actions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class UndoRedoHandler {
    private static final Logger logger = Logger.getLogger(UndoRedoHandler.class.getName());
    private static final String DO_UNDO_NAME = "UndoRedoHandler.doUndo";
    private static final String DO_REDO_NAME = "UndoRedoHandler.doRedo";
    private final JTextComponent textComponent;
    private final KeyStroke undoKeyStroke;
    private final KeyStroke redoKeyStroke;
    private final PropertyChangeListener documentPropertyChangeListener;
    private final UndoableEditListener undoableEditListener;

    public static UndoRedoHandler attach(JTextComponent textComponent) {
        return new UndoRedoHandler(textComponent);
    }

    public void detach() {
        this.textComponent.removePropertyChangeListener(this.documentPropertyChangeListener);
        Document document = this.textComponent.getDocument();
        document.removeUndoableEditListener(this.undoableEditListener);
        this.textComponent.getInputMap().remove(this.undoKeyStroke);
        this.textComponent.getActionMap().remove(DO_UNDO_NAME);
        this.textComponent.getInputMap().remove(this.redoKeyStroke);
        this.textComponent.getActionMap().remove(DO_REDO_NAME);
    }

    private UndoRedoHandler(JTextComponent textComponent) {
        this.textComponent = Objects.requireNonNull(textComponent, "The textComponent may not be null");
        this.undoKeyStroke = KeyStroke.getKeyStroke(90, 2);
        this.redoKeyStroke = KeyStroke.getKeyStroke(89, 2);
        this.documentPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("document".equals(e.getPropertyName())) {
                    Object newObject;
                    Document newDocument;
                    Object oldObject = e.getOldValue();
                    Document oldDocument = (Document)oldObject;
                    if (oldDocument != null) {
                        oldDocument.removeUndoableEditListener(UndoRedoHandler.this.undoableEditListener);
                    }
                    if ((newDocument = (Document)(newObject = e.getNewValue())) != null) {
                        newDocument.addUndoableEditListener(UndoRedoHandler.this.undoableEditListener);
                    }
                }
            }
        };
        textComponent.addPropertyChangeListener(this.documentPropertyChangeListener);
        final UndoManager undo = new UndoManager();
        Document document = textComponent.getDocument();
        this.undoableEditListener = new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                undo.addEdit(e.getEdit());
            }
        };
        document.addUndoableEditListener(this.undoableEditListener);
        textComponent.getInputMap().put(this.undoKeyStroke, DO_UNDO_NAME);
        textComponent.getActionMap().put(DO_UNDO_NAME, Actions.create(() -> {
            try {
                if (undo.canUndo()) {
                    undo.undo();
                }
            }
            catch (CannotUndoException ex) {
                logger.warning(ex.toString());
            }
        }));
        textComponent.getInputMap().put(this.redoKeyStroke, DO_REDO_NAME);
        textComponent.getActionMap().put(DO_REDO_NAME, Actions.create(() -> {
            try {
                if (undo.canRedo()) {
                    undo.redo();
                }
            }
            catch (CannotRedoException ex) {
                logger.warning(ex.toString());
            }
        }));
    }
}

