/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.tree.checkbox;

import de.javagl.common.ui.JTrees;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckBoxTree
extends JTree {
    static final Logger logger = Logger.getLogger(CheckBoxTree.class.getName());
    private static final long serialVersionUID = -7750694236316853481L;
    private final Map<Object, State> selectionStates = new LinkedHashMap<Object, State>();
    private final List<StateListener> stateListeners = new CopyOnWriteArrayList<StateListener>();

    public CheckBoxTree(TreeModel treeModel) {
        super(treeModel);
        CheckBoxRenderer checkBoxRenderer = new CheckBoxRenderer(this, this.getCellRenderer());
        this.setCellRenderer(checkBoxRenderer);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CheckBoxTree.this.handleMousePress(e);
            }
        });
        List<Object> allNodes = JTrees.getAllNodes(this.getModel());
        for (Object node : allNodes) {
            this.selectionStates.put(node, State.UNSELECTED);
        }
    }

    public void addStateListener(StateListener stateListener) {
        this.stateListeners.add(stateListener);
    }

    public void removeStateListener(StateListener stateListener) {
        this.stateListeners.add(stateListener);
    }

    private void fireStateChanged(Object node, State oldState, State newState) {
        for (StateListener stateListener : this.stateListeners) {
            stateListener.stateChanged(node, oldState, newState);
        }
    }

    public State getSelectionState(Object node) {
        return this.selectionStates.get(node);
    }

    public void selectAll() {
        this.setSelectionStateOfAll(State.SELECTED);
    }

    public void unselectAll() {
        this.setSelectionStateOfAll(State.UNSELECTED);
    }

    private void setSelectionStateOfAll(State state) {
        Objects.requireNonNull(state, "The state may not be null");
        List<Object> allNodes = JTrees.getAllNodes(this.getModel());
        for (Object node : allNodes) {
            this.setSelectionState(node, state);
        }
    }

    public void setSelectionState(Object node, State state) {
        this.setSelectionState(node, state, true);
    }

    private void setSelectionState(Object node, State state, boolean propagate) {
        Objects.requireNonNull(state, "The state may not be null");
        Objects.requireNonNull(node, "The node may not be null");
        State oldState = this.selectionStates.put(node, state);
        if (!state.equals((Object)oldState)) {
            this.fireStateChanged(node, oldState, state);
            if (propagate) {
                this.updateSelection(node);
            }
        }
        this.repaint();
    }

    private void handleMousePress(MouseEvent e) {
        int row = this.getRowForLocation(e.getX(), e.getY());
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        TreeCellRenderer cellRenderer = this.getCellRenderer();
        TreeNode node = (TreeNode)path.getLastPathComponent();
        Component cellRendererComponent = cellRenderer.getTreeCellRendererComponent(this, null, true, true, node.isLeaf(), row, true);
        Rectangle bounds = this.getRowBounds(row);
        Point localPoint = new Point();
        localPoint.x = e.getX() - bounds.x;
        localPoint.y = e.getY() - bounds.y;
        Container container = (Container)cellRendererComponent;
        Component clickedComponent = null;
        for (Component component : container.getComponents()) {
            Rectangle b = component.getBounds();
            if (!b.contains(localPoint)) continue;
            clickedComponent = component;
        }
        if (clickedComponent != null && clickedComponent instanceof JCheckBox) {
            this.toggleSelection(path);
            this.repaint();
        }
    }

    private void toggleSelection(TreePath path) {
        Object node = path.getLastPathComponent();
        State state = this.getSelectionState(node);
        if (state == null) {
            return;
        }
        if (state == State.SELECTED) {
            this.setSelectionState(node, State.UNSELECTED);
            this.updateSelection(node);
        } else if (state == State.UNSELECTED) {
            this.setSelectionState(node, State.SELECTED);
            this.updateSelection(node);
        } else {
            this.setSelectionState(node, State.SELECTED);
            this.updateSelection(node);
        }
    }

    private void updateSelection(Object node) {
        State newState = this.getSelectionState(node);
        List<Object> descendants = JTrees.getAllDescendants(this.getModel(), node);
        for (Object descendant : descendants) {
            this.setSelectionState(descendant, newState, false);
        }
        Object ancestor = JTrees.getParent(this.getModel(), node);
        while (ancestor != null) {
            List<Object> childrenOfAncestor = JTrees.getChildren(this.getModel(), ancestor);
            State stateForAncestor = this.computeState(childrenOfAncestor);
            this.setSelectionState(ancestor, stateForAncestor, false);
            ancestor = JTrees.getParent(this.getModel(), ancestor);
        }
    }

    private State computeState(List<Object> nodes) {
        LinkedHashSet<State> set = new LinkedHashSet<State>();
        for (Object node : nodes) {
            set.add(this.getSelectionState(node));
        }
        while (set.contains(null)) {
            logger.warning("null found in selection states");
            set.remove(null);
        }
        if (set.size() == 0) {
            logger.warning("Empty selection states");
            return State.SELECTED;
        }
        if (set.size() > 1) {
            return State.MIXED;
        }
        return (State)((Object)set.iterator().next());
    }

    private static class CheckBoxRenderer
    extends JPanel
    implements TreeCellRenderer {
        private static final long serialVersionUID = 6530238349185184391L;
        private final CheckBoxTree checkBoxTree;
        private final TreeCellRenderer delegate;
        private final JCheckBox checkBox;
        private Component currentDelegateComponent;

        CheckBoxRenderer(CheckBoxTree checkBoxTree, TreeCellRenderer delegate) {
            this.checkBoxTree = checkBoxTree;
            this.delegate = delegate;
            this.checkBox = new JCheckBox();
            this.setLayout(new BorderLayout());
            this.add((Component)this.checkBox, "West");
            this.checkBox.setOpaque(false);
            this.setOpaque(false);
        }

        @Override
        public void setFont(Font font) {
            if (font instanceof FontUIResource) {
                super.setFont(null);
            } else {
                super.setFont(font);
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component delegateComponent = this.delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            TreePath path = tree.getPathForRow(row);
            if (path != null) {
                Object node = path.getLastPathComponent();
                State state = this.checkBoxTree.getSelectionState(node);
                if (state == State.SELECTED) {
                    this.checkBox.setSelected(true);
                    this.checkBox.setEnabled(true);
                } else if (state == State.UNSELECTED) {
                    this.checkBox.setSelected(false);
                    this.checkBox.setEnabled(true);
                } else if (state == State.MIXED) {
                    this.checkBox.setSelected(true);
                    this.checkBox.setEnabled(false);
                }
            }
            if (this.currentDelegateComponent != null) {
                this.remove(this.currentDelegateComponent);
            }
            this.add(delegateComponent, "Center");
            this.currentDelegateComponent = delegateComponent;
            return this;
        }
    }

    public static interface StateListener {
        public void stateChanged(Object var1, State var2, State var3);
    }

    public static enum State {
        SELECTED,
        UNSELECTED,
        MIXED;

    }
}

