/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.tree.filtered;

import de.javagl.common.ui.JTrees;
import de.javagl.common.ui.tree.filtered.FilteredTreeModel;
import de.javagl.common.ui.tree.filtered.TreeModelFilter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FilteredTree {
    private final JTree tree;
    private FilteredTreeModel treeModel;
    private final Set<TreePath> expandedPaths = new HashSet<TreePath>();
    private final Set<TreePath> collapsedPaths = new HashSet<TreePath>();
    private final TreeExpansionListener expandedPathsListener = new TreeExpansionListener(){

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            FilteredTree.this.expandedPaths.add(event.getPath());
            FilteredTree.this.collapsedPaths.remove(event.getPath());
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            FilteredTree.this.expandedPaths.remove(event.getPath());
            FilteredTree.this.collapsedPaths.add(event.getPath());
        }
    };

    public static FilteredTree create(TreeModel treeModel) {
        return new FilteredTree(treeModel);
    }

    private FilteredTree(TreeModel delegateTreeModel) {
        this.treeModel = new FilteredTreeModel(delegateTreeModel);
        this.tree = new JTree(this.treeModel);
        this.tree.addTreeExpansionListener(this.expandedPathsListener);
    }

    public JTree getTree() {
        return this.tree;
    }

    public TreeModel getFilteredModel() {
        return this.treeModel;
    }

    public void setInputModel(TreeModel model) {
        Enumeration<TreePath> expandedDescendants = this.tree.getExpandedDescendants(new TreePath(this.treeModel.getRoot()));
        this.treeModel = new FilteredTreeModel(model);
        this.tree.setModel(this.treeModel);
        if (expandedDescendants != null) {
            while (expandedDescendants.hasMoreElements()) {
                TreePath expanded = expandedDescendants.nextElement();
                TreePath translatedPath = JTrees.translatePath(this.treeModel, expanded);
                if (translatedPath == null) continue;
                this.tree.expandPath(translatedPath);
            }
        }
    }

    public void setFilter(TreeModelFilter filter) {
        this.tree.removeTreeExpansionListener(this.expandedPathsListener);
        if (filter == null) {
            this.treeModel.setFilter(filter);
            for (TreePath path : this.expandedPaths) {
                this.tree.expandPath(path);
            }
            for (TreePath path : this.collapsedPaths) {
                this.tree.collapsePath(path);
            }
        } else {
            this.treeModel.setFilter(filter);
            JTrees.expandAllFixedHeight(this.tree);
        }
        this.tree.addTreeExpansionListener(this.expandedPathsListener);
    }
}

