/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.tree.filtered;

import de.javagl.common.ui.tree.filtered.FilteredTreeNode;
import de.javagl.common.ui.tree.filtered.TreeModelFilter;
import de.javagl.common.ui.tree.filtered.TreeModelFilters;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FilteredTreeModel
implements TreeModel {
    private final TreeModel delegate;
    private TreeModelFilter filter = TreeModelFilters.acceptingAll();
    private FilteredTreeNode root;
    private final Map<TreeNode, TreeNode> thisToDelegate;
    private final Map<TreeNode, TreeNode> delegateToThis;
    private final List<TreeModelListener> treeModelListeners;

    public FilteredTreeModel(TreeModel delegate) {
        this.delegate = delegate;
        this.treeModelListeners = new CopyOnWriteArrayList<TreeModelListener>();
        this.thisToDelegate = new HashMap<TreeNode, TreeNode>();
        this.delegateToThis = new HashMap<TreeNode, TreeNode>();
        this.init();
    }

    DefaultMutableTreeNode getDelegateNode(FilteredTreeNode filteredTreeNode) {
        return (DefaultMutableTreeNode)this.thisToDelegate.get(filteredTreeNode);
    }

    FilteredTreeNode getFilteredNode(Object treeNode) {
        return (FilteredTreeNode)this.delegateToThis.get(treeNode);
    }

    private void init() {
        TreeNode delegateRoot = null;
        if (this.delegate != null) {
            delegateRoot = (TreeNode)this.delegate.getRoot();
        }
        this.thisToDelegate.clear();
        this.delegateToThis.clear();
        if (delegateRoot == null) {
            this.root = null;
            return;
        }
        this.root = this.createNode(delegateRoot);
    }

    private FilteredTreeNode createNode(TreeNode delegateNode) {
        FilteredTreeNode node = new FilteredTreeNode(this, delegateNode);
        this.delegateToThis.put(delegateNode, node);
        this.thisToDelegate.put(node, delegateNode);
        Enumeration<? extends TreeNode> delegateChildren = delegateNode.children();
        while (delegateChildren.hasMoreElements()) {
            TreeNode delegateChild = delegateChildren.nextElement();
            this.createNode(delegateChild);
        }
        return node;
    }

    public void setFilter(TreeModelFilter filter) {
        this.filter = filter;
        if (this.filter == null) {
            this.filter = TreeModelFilters.acceptingAll();
        }
        if (this.root != null) {
            this.root.notifyFilterChanged();
        }
        this.fireTreeStructureChanged(this, new TreeNode[]{this.root}, null, null);
    }

    Stream<TreeNode> getFiltered(Stream<TreeNode> delegateNodes) {
        return delegateNodes.filter(delegateNode -> this.filter.acceptNode(this, (TreeNode)delegateNode)).map(delegateNode -> this.delegateToThis.get(delegateNode)).filter(filteredNode -> filteredNode != null);
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        for (TreeModelListener listener : this.treeModelListeners) {
            listener.treeStructureChanged(new TreeModelEvent(source, path, childIndices, children));
        }
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        MutableTreeNode aNode = (MutableTreeNode)path.getLastPathComponent();
        aNode.setUserObject(newValue);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }
}

