/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.tree.filtered;

import de.javagl.common.ui.tree.filtered.FilteredTreeModel;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class FilteredTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -8766897308902463690L;
    private final FilteredTreeModel filteredTreeModel;
    private final TreeNode delegateNode;
    private Vector<TreeNode> filteredChildren;

    FilteredTreeNode(FilteredTreeModel filteredTreeModel, TreeNode delegateNode) {
        this.filteredTreeModel = filteredTreeModel;
        this.delegateNode = delegateNode;
        this.filteredChildren = null;
    }

    @Override
    public boolean isLeaf() {
        return this.delegateNode.isLeaf();
    }

    @Override
    public Object getUserObject() {
        DefaultMutableTreeNode delegateNode = this.filteredTreeModel.getDelegateNode(this);
        return delegateNode.getUserObject();
    }

    @Override
    public void setUserObject(Object userObject) {
        DefaultMutableTreeNode delegateNode = this.filteredTreeModel.getDelegateNode(this);
        delegateNode.setUserObject(userObject);
    }

    @Override
    public Object[] getUserObjectPath() {
        DefaultMutableTreeNode delegateNode = this.filteredTreeModel.getDelegateNode(this);
        Object[] delegateResult = delegateNode.getUserObjectPath();
        Object[] result = new Object[delegateResult.length];
        for (int i = 0; i < delegateResult.length; ++i) {
            result[i] = this.filteredTreeModel.getFilteredNode(delegateResult[i]);
        }
        return super.getUserObjectPath();
    }

    @Override
    public TreeNode getParent() {
        return this.filteredTreeModel.getFilteredNode(this.delegateNode.getParent());
    }

    private Vector<TreeNode> getFilteredChildren() {
        if (this.filteredChildren == null) {
            Enumeration<? extends TreeNode> enumeration = this.delegateNode.children();
            Stream<TreeNode> stream = FilteredTreeNode.enumerationAsStream(enumeration);
            this.filteredChildren = this.filteredTreeModel.getFiltered(stream).collect(Collectors.toCollection(Vector::new));
        }
        return this.filteredChildren;
    }

    void notifyFilterChanged() {
        for (TreeNode child : this.getFilteredChildren()) {
            ((FilteredTreeNode)child).notifyFilterChanged();
        }
        this.filteredChildren = null;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getFilteredChildren().indexOf(node);
    }

    @Override
    public int getChildCount() {
        return this.getFilteredChildren().size();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.getFilteredChildren().get(childIndex);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.delegateNode.getAllowsChildren();
    }

    public Enumeration children() {
        return this.getFilteredChildren().elements();
    }

    @Override
    public String toString() {
        return this.delegateNode.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return this.delegateNode.equals(object);
    }

    public int hashCode() {
        return this.delegateNode.hashCode();
    }

    private static <T> Stream<T> enumerationAsStream(final Enumeration<? extends T> e) {
        Iterator iterator = new Iterator<T>(){

            @Override
            public T next() {
                return e.nextElement();
            }

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }
}

