/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.tree.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public abstract class GenericTreeCellRenderer
implements TreeCellRenderer {
    private final DefaultTreeCellRenderer delegate = new DefaultTreeCellRenderer();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, final boolean selected, boolean expanded, boolean leaf, int row, final boolean hasFocus) {
        this.delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        JPanel component = new JPanel(new BorderLayout(5, 0));
        component.setOpaque(false);
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(this.delegate.getIcon());
        component.add((Component)iconLabel, "West");
        JPanel container = new JPanel(new GridLayout(1, 1)){
            private static final long serialVersionUID = -7852184126192862958L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(this.getBackgroundColor());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }

            private Color getBackgroundColor() {
                if (selected || hasFocus) {
                    return GenericTreeCellRenderer.this.delegate.getBackgroundSelectionColor();
                }
                Color color = GenericTreeCellRenderer.this.delegate.getBackgroundNonSelectionColor();
                if (color == null) {
                    return GenericTreeCellRenderer.this.delegate.getBackground();
                }
                return color;
            }
        };
        component.add((Component)container, "Center");
        this.prepare(value, container);
        if (selected || hasFocus) {
            container.setBorder(BorderFactory.createLineBorder(this.delegate.getBorderSelectionColor()));
            container.setBackground(this.delegate.getBackgroundSelectionColor());
        } else {
            container.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            container.setBackground(null);
        }
        return component;
    }

    protected void prepare(Object nodeObject, JPanel container) {
    }
}

