/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.common.ui.utils.desktop;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class JDesktopPaneLayout {
    private final JDesktopPaneLayout parent;
    private final JDesktopPane desktopPane;
    private final LayoutContainer container;
    private final LayoutContainer rootContainer;
    private final Map<JInternalFrame, FrameComponent> frameToComponent;

    public JDesktopPaneLayout(JDesktopPane desktopPane) {
        this(null, desktopPane, null);
    }

    private JDesktopPaneLayout(JDesktopPaneLayout parent, JDesktopPane desktopPane, LayoutContainer rootContainer) {
        this.parent = parent;
        this.desktopPane = desktopPane;
        this.container = new LayoutContainer(this);
        this.rootContainer = rootContainer == null ? this.container : rootContainer;
        this.frameToComponent = new HashMap<JInternalFrame, FrameComponent>();
    }

    public JDesktopPaneLayout createChild() {
        return new JDesktopPaneLayout(this, this.desktopPane, this.rootContainer);
    }

    public void add(JDesktopPaneLayout child) {
        this.add(child, null);
    }

    public void add(JDesktopPaneLayout child, Object constraints) {
        this.add(child, constraints, -1);
    }

    public void add(JDesktopPaneLayout child, Object constraints, int index) {
        if (child.parent != this) {
            throw new IllegalArgumentException("Layout is not a child of this layout");
        }
        this.container.add(child.container, constraints, index);
    }

    public void remove(JDesktopPaneLayout child) {
        if (child.parent != this) {
            throw new IllegalArgumentException("Layout is not a child of this layout");
        }
        this.container.remove(child.container);
    }

    public void setLayout(LayoutManager layoutManager) {
        this.container.setLayout(layoutManager);
    }

    public void add(JInternalFrame internalFrame) {
        this.add(internalFrame, null);
    }

    public void add(JInternalFrame internalFrame, Object constraints) {
        this.add(internalFrame, constraints, -1);
    }

    public void add(JInternalFrame internalFrame, Object constraints, int index) {
        FrameComponent frameComponent = new FrameComponent(internalFrame, constraints, index);
        this.frameToComponent.put(internalFrame, frameComponent);
        if (!internalFrame.isIcon()) {
            this.container.add(frameComponent, constraints, index);
        }
    }

    void remove(JInternalFrame internalFrame) {
        Component component = this.frameToComponent.get(internalFrame);
        this.container.remove(component);
    }

    public void validate() {
        Dimension size = this.desktopPane.getSize();
        size.height -= this.computeDesktopIconsSpace();
        this.layoutInternalFrames(size);
    }

    private int computeDesktopIconsSpace() {
        for (JInternalFrame f : this.frameToComponent.keySet()) {
            if (!f.isIcon()) continue;
            JInternalFrame.JDesktopIcon desktopIcon = f.getDesktopIcon();
            return desktopIcon.getPreferredSize().height;
        }
        return 0;
    }

    private void layoutInternalFrames(Dimension size) {
        this.container.setSize(size);
        this.callDoLayout(this.container);
        this.applyLayout();
    }

    private void callDoLayout(Container container) {
        container.doLayout();
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!(component instanceof Container)) continue;
            Container subContainer = (Container)component;
            this.callDoLayout(subContainer);
        }
    }

    private void applyLayout() {
        int n = this.container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.container.getComponent(i);
            if (component instanceof FrameComponent) {
                FrameComponent frameComponent = (FrameComponent)component;
                JInternalFrame internalFrame = frameComponent.getInternalFrame();
                Rectangle bounds = SwingUtilities.convertRectangle(this.container, component.getBounds(), this.rootContainer);
                internalFrame.setBounds(bounds);
                continue;
            }
            LayoutContainer childLayoutContainer = (LayoutContainer)component;
            childLayoutContainer.owner.applyLayout();
        }
    }

    private class FrameComponent
    extends JPanel {
        private static final long serialVersionUID = 7397992807282457681L;
        private final JInternalFrame internalFrame;

        FrameComponent(JInternalFrame internalFrame, final Object constraints, final int index) {
            this.internalFrame = internalFrame;
            internalFrame.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameIconified(InternalFrameEvent e) {
                    JDesktopPaneLayout.this.container.remove(FrameComponent.this);
                }

                @Override
                public void internalFrameDeiconified(InternalFrameEvent e) {
                    JDesktopPaneLayout.this.container.add(FrameComponent.this, constraints, index);
                }

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    JDesktopPaneLayout.this.container.remove(FrameComponent.this);
                }
            });
        }

        JInternalFrame getInternalFrame() {
            return this.internalFrame;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.internalFrame.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.internalFrame.getMaximumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.internalFrame.getMinimumSize();
        }
    }

    private static class LayoutContainer
    extends Container {
        private static final long serialVersionUID = 6455895807345631762L;
        private final JDesktopPaneLayout owner;

        LayoutContainer(JDesktopPaneLayout owner) {
            this.owner = owner;
        }
    }
}

