/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.geom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;

public class AffineTransforms {
    public static AffineTransform invert(AffineTransform atSrc, AffineTransform atDst) {
        try {
            if (atDst == null) {
                return atSrc.createInverse();
            }
            atDst.setTransform(atSrc);
            atDst.invert();
            return atDst;
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("Non-invertible transform", e);
        }
    }

    public static <T> Function<T, AffineTransform> scaling(final ToDoubleFunction<? super T> xScalingFunction, final ToDoubleFunction<? super T> yScalingFunction) {
        return new Function<T, AffineTransform>(){

            @Override
            public AffineTransform apply(T t) {
                double x = xScalingFunction.applyAsDouble(t);
                double y = yScalingFunction.applyAsDouble(t);
                return AffineTransform.getScaleInstance(x, y);
            }
        };
    }

    public static <T> Function<T, AffineTransform> scaling(final ToDoubleFunction<? super T> scalingFunction) {
        return new Function<T, AffineTransform>(){

            @Override
            public AffineTransform apply(T t) {
                double s = scalingFunction.applyAsDouble(t);
                return AffineTransform.getScaleInstance(s, s);
            }
        };
    }

    public static <T> Function<T, AffineTransform> rotating(final ToDoubleFunction<? super T> angleRadFunction) {
        return new Function<T, AffineTransform>(){

            @Override
            public AffineTransform apply(T t) {
                double angleRad = angleRadFunction.applyAsDouble(t);
                return AffineTransform.getRotateInstance(angleRad);
            }
        };
    }

    public static <T> Function<T, AffineTransform> rotating(final ToDoubleFunction<? super T> angleRadFunction, final double anchorX, final double anchorY) {
        return new Function<T, AffineTransform>(){

            @Override
            public AffineTransform apply(T t) {
                double angleRad = angleRadFunction.applyAsDouble(t);
                return AffineTransform.getRotateInstance(angleRad, anchorX, anchorY);
            }
        };
    }

    public static <T> Function<T, AffineTransform> translate(final ToDoubleFunction<? super T> xTranslationFunction, final ToDoubleFunction<? super T> yTranslationFunction) {
        return new Function<T, AffineTransform>(){

            @Override
            public AffineTransform apply(T t) {
                double x = xTranslationFunction.applyAsDouble(t);
                double y = yTranslationFunction.applyAsDouble(t);
                return AffineTransform.getTranslateInstance(x, y);
            }
        };
    }

    public static <T> Function<T, AffineTransform> compose(final Function<? super T, ? extends AffineTransform> f0, final Function<? super T, ? extends AffineTransform> f1) {
        return new Function<T, AffineTransform>(){

            @Override
            public AffineTransform apply(T t) {
                AffineTransform at0 = (AffineTransform)f0.apply(t);
                AffineTransform at1 = (AffineTransform)f1.apply(t);
                if (at0 == null && at1 == null) {
                    return null;
                }
                if (at1 == null) {
                    return new AffineTransform(at1);
                }
                AffineTransform at = new AffineTransform(at0);
                at.concatenate(at1);
                return at;
            }
        };
    }

    public static double computeDistanceX(AffineTransform at, double distanceX) {
        double dx = at.getScaleX() * distanceX;
        double dy = at.getShearY() * distanceX;
        double result = Math.sqrt(dx * dx + dy * dy);
        return result;
    }

    public static double computeDistanceY(AffineTransform at, double distanceY) {
        double dx = at.getShearX() * distanceY;
        double dy = at.getScaleY() * distanceY;
        double result = Math.sqrt(dx * dx + dy * dy);
        return result;
    }

    public static double computeX(AffineTransform at, Point2D p) {
        return AffineTransforms.computeX(at, p.getX(), p.getY());
    }

    public static double computeX(AffineTransform at, double x, double y) {
        return at.getScaleX() * x + at.getShearX() * y + at.getTranslateX();
    }

    public static double computeY(AffineTransform at, Point2D p) {
        return AffineTransforms.computeY(at, p.getX(), p.getY());
    }

    public static double computeY(AffineTransform at, double x, double y) {
        return at.getShearY() * x + at.getScaleY() * y + at.getTranslateY();
    }

    public static Shape createTransformedShape(AffineTransform at, Shape shape) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)shape;
            if (!AffineTransforms.hasRotation(at)) {
                if (!AffineTransforms.hasScale(at)) {
                    return AffineTransforms.createTranslated(at, r);
                }
                return AffineTransforms.createScaledAndTranslated(at, r);
            }
        } else if (shape instanceof Line2D) {
            Line2D l = (Line2D)shape;
            if (!AffineTransforms.hasRotation(at)) {
                if (!AffineTransforms.hasScale(at)) {
                    return AffineTransforms.createTranslated(at, l);
                }
                return AffineTransforms.createScaledAndTranslated(at, l);
            }
        }
        return at.createTransformedShape(shape);
    }

    private static Rectangle2D createTranslated(AffineTransform at, Rectangle2D r) {
        Rectangle2D.Double result = new Rectangle2D.Double(r.getX() + at.getTranslateX(), r.getY() + at.getTranslateY(), r.getWidth(), r.getHeight());
        return result;
    }

    private static Rectangle2D createScaledAndTranslated(AffineTransform at, Rectangle2D r) {
        Rectangle2D.Double result = new Rectangle2D.Double(r.getX() * at.getScaleX() + at.getTranslateX(), r.getY() * at.getScaleY() + at.getTranslateY(), r.getWidth() * at.getScaleX(), r.getHeight() * at.getScaleY());
        return result;
    }

    private static Line2D createTranslated(AffineTransform at, Line2D l) {
        Line2D.Double result = new Line2D.Double(l.getX1() + at.getTranslateX(), l.getY1() + at.getTranslateY(), l.getX2() + at.getTranslateX(), l.getY2() + at.getTranslateY());
        return result;
    }

    private static Line2D createScaledAndTranslated(AffineTransform at, Line2D l) {
        Line2D.Double result = new Line2D.Double(l.getX1() * at.getScaleX() + at.getTranslateX(), l.getY1() * at.getScaleY() + at.getTranslateY(), l.getX2() * at.getScaleX() + at.getTranslateX(), l.getY2() * at.getScaleY() + at.getTranslateY());
        return result;
    }

    private static boolean hasRotation(AffineTransform at) {
        int type = at.getType();
        if (type == 32) {
            return true;
        }
        return (type & 0x10) != 0 || (type & 8) != 0;
    }

    private static boolean hasScale(AffineTransform at) {
        int type = at.getType();
        if (type == 32) {
            return true;
        }
        return (type & 2) != 0 || (type & 4) != 0;
    }

    public static String toString(AffineTransform at) {
        return AffineTransforms.toString(at, "%f");
    }

    public static String toString(AffineTransform at, String format) {
        return AffineTransforms.toString(at, Locale.getDefault(), format);
    }

    public static String toString(AffineTransform at, Locale locale, String format) {
        int cellSize = 10;
        String s00 = String.format(locale, format, at.getScaleX());
        String s01 = String.format(locale, format, at.getShearX());
        String s02 = String.format(locale, format, at.getTranslateX());
        String s10 = String.format(locale, format, at.getShearY());
        String s11 = String.format(locale, format, at.getScaleY());
        String s12 = String.format(locale, format, at.getTranslateY());
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%" + cellSize + "s", s00)).append(" ");
        sb.append(String.format("%" + cellSize + "s", s01)).append(" ");
        sb.append(String.format("%" + cellSize + "s", s02)).append("\n");
        sb.append(String.format("%" + cellSize + "s", s10)).append(" ");
        sb.append(String.format("%" + cellSize + "s", s11)).append(" ");
        sb.append(String.format("%" + cellSize + "s", s12)).append(" ");
        return sb.toString();
    }

    private AffineTransforms() {
    }
}

