/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.geom;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CatmullRomSpline {
    private double alpha;
    private final List<Point2D> controlPoints;
    private final int stepsPerSegment;
    private final List<Point2D> interpolatedPoints;
    private boolean updateRequired = true;

    public static CatmullRomSpline create(List<? extends Point2D> points, int stepsPerSegment, double alpha) {
        return new CatmullRomSpline(points, stepsPerSegment, alpha);
    }

    private CatmullRomSpline(List<? extends Point2D> points, int stepsPerSegment, double alpha) {
        this.stepsPerSegment = stepsPerSegment;
        this.alpha = alpha;
        this.controlPoints = CatmullRomSpline.createPoints(points.size() + 2);
        int numInterpolatedPoints = (points.size() - 1) * stepsPerSegment + 1;
        this.interpolatedPoints = CatmullRomSpline.createPoints(numInterpolatedPoints);
        this.updateControlPoints(points);
    }

    private static List<Point2D> createPoints(int n) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (int i = 0; i < n; ++i) {
            points.add(new Point2D.Double());
        }
        return points;
    }

    public void setInterpolation(double alpha) {
        this.alpha = alpha;
        this.updateRequired = true;
    }

    void updateControlPoint(int index, Point2D point) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index " + index + " must be positive");
        }
        if (index >= this.controlPoints.size() - 1) {
            throw new IndexOutOfBoundsException("Index was " + index + ", but number of control " + "points was " + (this.controlPoints.size() - 2));
        }
        Point2D cp = this.controlPoints.get(index + 1);
        cp.setLocation(point);
        this.updateRequired = true;
    }

    public void updateControlPoints(List<? extends Point2D> points) {
        if (points.size() != this.controlPoints.size() - 2) {
            throw new IllegalArgumentException("Expected " + (this.controlPoints.size() - 2) + " points, but got " + points.size());
        }
        for (int j = 0; j < points.size(); ++j) {
            Point2D p = points.get(j);
            Point2D cp = this.controlPoints.get(j + 1);
            cp.setLocation(p);
        }
        this.updateRequired = true;
    }

    public List<Point2D> getInterpolatedPoints() {
        this.validatePoints();
        return Collections.unmodifiableList(this.interpolatedPoints);
    }

    private void validatePoints() {
        if (this.updateRequired) {
            this.updateAdditionalControlPoints();
            this.updateInterpolatedPoints();
            this.updateRequired = false;
        }
    }

    private void updateInterpolatedPoints() {
        for (int i = 0; i < this.controlPoints.size() - 3; ++i) {
            int stepsInCurrentSegment = this.stepsPerSegment;
            int lastStepinSegment = stepsInCurrentSegment++;
            if (i == this.controlPoints.size() - 4) {
                lastStepinSegment = stepsInCurrentSegment - 1;
            }
            this.updateInterpolatedPoints(i, stepsInCurrentSegment, lastStepinSegment);
        }
    }

    private void updateAdditionalControlPoints() {
        Point2D p0 = this.controlPoints.get(1);
        Point2D p1 = this.controlPoints.get(2);
        Point2D cp0 = this.controlPoints.get(0);
        CatmullRomSpline.sub(p1, p0, cp0);
        CatmullRomSpline.sub(p0, cp0, cp0);
        Point2D py = this.controlPoints.get(this.controlPoints.size() - 3);
        Point2D pz = this.controlPoints.get(this.controlPoints.size() - 2);
        Point2D cpz = this.controlPoints.get(this.controlPoints.size() - 1);
        CatmullRomSpline.sub(pz, py, cpz);
        CatmullRomSpline.add(pz, cpz, cpz);
    }

    private static void sub(Point2D p0, Point2D p1, Point2D result) {
        result.setLocation(p0.getX() - p1.getX(), p0.getY() - p1.getY());
    }

    private static void add(Point2D p0, Point2D p1, Point2D result) {
        result.setLocation(p0.getX() + p1.getX(), p0.getY() + p1.getY());
    }

    private void updateInterpolatedPoints(int index, int stepsInCurrentSegment, int lastStepInSegment) {
        Point2D p0 = this.controlPoints.get(index + 0);
        Point2D p1 = this.controlPoints.get(index + 1);
        Point2D p2 = this.controlPoints.get(index + 2);
        Point2D p3 = this.controlPoints.get(index + 3);
        double t0 = 0.0;
        double t1 = 1.0;
        double t2 = 2.0;
        double t3 = 3.0;
        if (this.alpha != 0.0) {
            double exponent = this.alpha * 0.5;
            double dx01 = p1.getX() - p0.getX();
            double dy01 = p1.getY() - p0.getY();
            double d01 = dx01 * dx01 + dy01 * dy01;
            t1 = t0 + Math.pow(d01, exponent);
            double dx12 = p2.getX() - p1.getX();
            double dy12 = p2.getY() - p1.getY();
            double d12 = dx12 * dx12 + dy12 * dy12;
            t2 = t1 + Math.pow(d12, exponent);
            double dx23 = p3.getX() - p2.getX();
            double dy23 = p3.getY() - p2.getY();
            double d23 = dx23 * dx23 + dy23 * dy23;
            t3 = t2 + Math.pow(d23, exponent);
        }
        double invStep = 1.0 / (double)lastStepInSegment;
        for (int i = 0; i < stepsInCurrentSegment; ++i) {
            double t = (double)i * invStep;
            int interpolatedPointIndex = index * this.stepsPerSegment + i;
            Point2D interpolatedPoint = this.interpolatedPoints.get(interpolatedPointIndex);
            CatmullRomSpline.interpolate(p0, p1, p2, p3, t0, t1, t2, t3, t1 + t * (t2 - t1), interpolatedPoint);
        }
    }

    private static void interpolate(Point2D p0, Point2D p1, Point2D p2, Point2D p3, double t0, double t1, double t2, double t3, double t, Point2D result) {
        double x0 = p0.getX();
        double y0 = p0.getY();
        double x1 = p1.getX();
        double y1 = p1.getY();
        double x2 = p2.getX();
        double y2 = p2.getY();
        double x3 = p3.getX();
        double y3 = p3.getY();
        double invDt01 = 1.0 / (t1 - t0);
        double invDt12 = 1.0 / (t2 - t1);
        double invDt23 = 1.0 / (t3 - t2);
        double f01a = (t1 - t) * invDt01;
        double f01b = (t - t0) * invDt01;
        double f12a = (t2 - t) * invDt12;
        double f12b = (t - t1) * invDt12;
        double f23a = (t3 - t) * invDt23;
        double f23b = (t - t2) * invDt23;
        double x01 = f01a * x0 + f01b * x1;
        double y01 = f01a * y0 + f01b * y1;
        double x12 = f12a * x1 + f12b * x2;
        double y12 = f12a * y1 + f12b * y2;
        double x23 = f23a * x2 + f23b * x3;
        double y23 = f23a * y2 + f23b * y3;
        double invDt02 = 1.0 / (t2 - t0);
        double invDt13 = 1.0 / (t3 - t1);
        double f012a = (t2 - t) * invDt02;
        double f012b = (t - t0) * invDt02;
        double f123a = (t3 - t) * invDt13;
        double f123b = (t - t1) * invDt13;
        double x012 = f012a * x01 + f012b * x12;
        double y012 = f012a * y01 + f012b * y12;
        double x123 = f123a * x12 + f123b * x23;
        double y123 = f123a * y12 + f123b * y23;
        double resultX = f12a * x012 + f12b * x123;
        double resultY = f12a * y012 + f12b * y123;
        result.setLocation(resultX, resultY);
    }
}

