/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.geom;

import de.javagl.geom.Lines;
import de.javagl.geom.Points;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ConvexHull {
    public static List<Point2D> compute(List<? extends Point2D> inputPoints) {
        if (inputPoints.size() <= 3) {
            return new ArrayList<Point2D>(inputPoints);
        }
        ArrayList<Point2D> points = new ArrayList<Point2D>(inputPoints);
        Point2D referencePoint = Collections.min(points, Points.YX_COMPARATOR);
        Comparator<Point2D> comparator = Points.byAngleComparator(referencePoint);
        Collections.sort(points, comparator);
        List<Point2D> newPoints = ConvexHull.makeAnglesUnique(points);
        List<Point2D> result = ConvexHull.scan(newPoints);
        return result;
    }

    private static List<Point2D> scan(List<Point2D> points) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        result.add(points.get(0));
        result.add(points.get(1));
        for (int i = 2; i < points.size(); ++i) {
            double y;
            double x;
            double y1;
            double x1;
            double y0;
            Point2D p0 = (Point2D)result.get(result.size() - 1);
            Point2D p1 = (Point2D)result.get(result.size() - 2);
            Point2D p = points.get(i);
            double x0 = p0.getX();
            int r = Line2D.relativeCCW(x0, y0 = p0.getY(), x1 = p1.getX(), y1 = p1.getY(), x = p.getX(), y = p.getY());
            if (r >= 0) {
                result.add(p);
                continue;
            }
            result.remove(result.size() - 1);
            --i;
        }
        return result;
    }

    private static List<Point2D> makeAnglesUnique(List<Point2D> points) {
        Point2D referencePoint = points.get(0);
        ArrayList<Point2D> newPoints = new ArrayList<Point2D>();
        newPoints.add(referencePoint);
        double previousAngle = Math.PI * 2;
        double previousDistanceSquared = Double.MAX_VALUE;
        for (int i = 1; i < points.size(); ++i) {
            Point2D p = points.get(i);
            double angle = Lines.angleToX(referencePoint, p);
            if (Math.abs(angle - previousAngle) > (double)1.0E-8f) {
                newPoints.add(p);
            } else {
                double distanceSquared = referencePoint.distanceSq(p);
                if (distanceSquared > previousDistanceSquared) {
                    newPoints.set(newPoints.size() - 1, p);
                }
            }
            previousAngle = angle;
            previousDistanceSquared = referencePoint.distanceSq(p);
        }
        return newPoints;
    }

    private ConvexHull() {
    }
}

