/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.geom;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class Intersections {
    private static double dotPerp(double x0, double y0, double x1, double y1) {
        return x0 * y1 - y0 * x1;
    }

    private Intersections() {
    }

    public static class LineLine {
        public static boolean intersect(Line2D line0, Line2D line1, Point2D relativeLocation, Point2D absoluteLocation) {
            return LineLine.intersect(line0.getX1(), line0.getY1(), line0.getX2(), line0.getY2(), line1.getX1(), line1.getY1(), line1.getX2(), line1.getY2(), relativeLocation, absoluteLocation);
        }

        public static boolean intersect(double s0x0, double s0y0, double s0x1, double s0y1, double s1x0, double s1y0, double s1x1, double s1y1, Point2D relativeLocation, Point2D absoluteLocation) {
            double dir1y;
            double invLen1;
            double dir1x;
            double dir0y;
            double dx0 = s0x1 - s0x0;
            double dy0 = s0y1 - s0y0;
            double dx1 = s1x1 - s1x0;
            double dy1 = s1y1 - s1y0;
            double invLen0 = 1.0 / Math.sqrt(dx0 * dx0 + dy0 * dy0);
            double dir0x = dx0 * invLen0;
            double dot = Intersections.dotPerp(dir0x, dir0y = dy0 * invLen0, dir1x = dx1 * (invLen1 = 1.0 / Math.sqrt(dx1 * dx1 + dy1 * dy1)), dir1y = dy1 * invLen1);
            if (Math.abs(dot) > (double)1.0E-8f) {
                if (relativeLocation != null || absoluteLocation != null) {
                    double c0x = s0x0 + dx0 * 0.5;
                    double c0y = s0y0 + dy0 * 0.5;
                    double c1x = s1x0 + dx1 * 0.5;
                    double c1y = s1y0 + dy1 * 0.5;
                    double cdx = c1x - c0x;
                    double cdy = c1y - c0y;
                    double dot0 = Intersections.dotPerp(cdx, cdy, dir0x, dir0y);
                    double dot1 = Intersections.dotPerp(cdx, cdy, dir1x, dir1y);
                    double invDot = 1.0 / dot;
                    double s0 = dot1 * invDot;
                    double s1 = dot0 * invDot;
                    if (relativeLocation != null) {
                        double n0 = s0 * invLen0 + 0.5;
                        double n1 = s1 * invLen1 + 0.5;
                        relativeLocation.setLocation(n0, n1);
                    }
                    if (absoluteLocation != null) {
                        double x = c0x + s0 * dir0x;
                        double y = c0y + s0 * dir0y;
                        absoluteLocation.setLocation(x, y);
                    }
                }
                return true;
            }
            return false;
        }

        private LineLine() {
        }
    }

    public static class SegmentSegment {
        public static boolean intersect(Line2D line0, Line2D line1, Point2D relativeLocation, Point2D absoluteLocation) {
            return SegmentSegment.intersect(line0.getX1(), line0.getY1(), line0.getX2(), line0.getY2(), line1.getX1(), line1.getY1(), line1.getX2(), line1.getY2(), relativeLocation, absoluteLocation);
        }

        public static boolean intersect(double s0x0, double s0y0, double s0x1, double s0y1, double s1x0, double s1y0, double s1x1, double s1y1, Point2D relativeLocation, Point2D absoluteLocation) {
            boolean intersect;
            if (relativeLocation == null) {
                relativeLocation = new Point2D.Double();
            }
            return (intersect = LineLine.intersect(s0x0, s0y0, s0x1, s0y1, s1x0, s1y0, s1x1, s1y1, relativeLocation, absoluteLocation)) && relativeLocation.getX() >= 0.0 && relativeLocation.getX() <= 1.0 && relativeLocation.getY() >= 0.0 && relativeLocation.getY() <= 1.0;
        }

        private SegmentSegment() {
        }
    }
}

