/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.geom;

import de.javagl.geom.ConvexHull;
import de.javagl.geom.Lines;
import de.javagl.geom.Points;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class OrientedBoundingBoxes {
    public static List<Point2D> computeMinimumOrientedBoundingBoxCorners(List<? extends Point2D> points) {
        List<Point2D> convexHullPoints = ConvexHull.compute(points);
        int alignmentPointIndex = OrientedBoundingBoxes.computeAlignmentPointIndex(convexHullPoints);
        int nextIndex = (alignmentPointIndex + 1) % convexHullPoints.size();
        Point2D p0 = convexHullPoints.get(alignmentPointIndex);
        Point2D p1 = convexHullPoints.get(nextIndex);
        AffineTransform at = OrientedBoundingBoxes.computeAlignmentTransform(p0, p1);
        List<Point2D> transformedPoints = Points.transform(at, points);
        Rectangle2D r = Points.computeBounds(transformedPoints);
        ArrayList<Point2D.Double> alignedCorners = new ArrayList<Point2D.Double>();
        alignedCorners.add(new Point2D.Double(r.getMinX(), r.getMinY()));
        alignedCorners.add(new Point2D.Double(r.getMaxX(), r.getMinY()));
        alignedCorners.add(new Point2D.Double(r.getMaxX(), r.getMaxY()));
        alignedCorners.add(new Point2D.Double(r.getMinX(), r.getMaxY()));
        AffineTransform iat = OrientedBoundingBoxes.computeInverseAlignmentTransform(p0, p1);
        List<Point2D> corners = Points.transform(iat, alignedCorners);
        return corners;
    }

    private static int computeAlignmentPointIndex(List<Point2D> points) {
        double minArea = Double.MAX_VALUE;
        int minAreaIndex = -1;
        for (int i = 0; i < points.size(); ++i) {
            Point2D p1;
            Point2D p0 = points.get(i);
            AffineTransform at = OrientedBoundingBoxes.computeAlignmentTransform(p0, p1 = points.get((i + 1) % points.size()));
            List<Point2D> transformedPoints = Points.transform(at, points);
            Rectangle2D bounds = Points.computeBounds(transformedPoints);
            double area = bounds.getWidth() * bounds.getHeight();
            if (!(area < minArea)) continue;
            minArea = area;
            minAreaIndex = i;
        }
        return minAreaIndex;
    }

    private static AffineTransform computeAlignmentTransform(Point2D p0, Point2D p1) {
        double angleRad = Lines.angleToX(p0, p1);
        AffineTransform at = AffineTransform.getRotateInstance(-angleRad);
        at.concatenate(AffineTransform.getTranslateInstance(-p0.getX(), -p0.getY()));
        return at;
    }

    private static AffineTransform computeInverseAlignmentTransform(Point2D p0, Point2D p1) {
        double angleRad = Lines.angleToX(p0, p1);
        AffineTransform at = AffineTransform.getTranslateInstance(p0.getX(), p0.getY());
        at.concatenate(AffineTransform.getRotateInstance(angleRad));
        return at;
    }

    private OrientedBoundingBoxes() {
    }
}

