/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.geom;

import de.javagl.geom.Lines;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class Points {
    static final Comparator<Point2D> YX_COMPARATOR = new Comparator<Point2D>(){

        @Override
        public int compare(Point2D p0, Point2D p1) {
            int cy = Double.compare(p0.getY(), p1.getY());
            if (cy != 0) {
                return cy;
            }
            return Double.compare(p0.getX(), p1.getX());
        }
    };
    static final Comparator<Point2D> XY_COMPARATOR = new Comparator<Point2D>(){

        @Override
        public int compare(Point2D p0, Point2D p1) {
            int cx = Double.compare(p0.getX(), p1.getX());
            if (cx != 0) {
                return cx;
            }
            return Double.compare(p0.getY(), p1.getY());
        }
    };

    public static Comparator<Point2D> colexicographicalComparator() {
        return YX_COMPARATOR;
    }

    public static Comparator<Point2D> lexicographicalComparator() {
        return XY_COMPARATOR;
    }

    public static Comparator<Point2D> byAngleComparator(Point2D center) {
        return Points.byAngleComparator(center.getX(), center.getY());
    }

    public static Comparator<Point2D> byAngleComparator(final double centerX, final double centerY) {
        return new Comparator<Point2D>(){

            @Override
            public int compare(Point2D p0, Point2D p1) {
                double angle0 = Lines.angleToX(centerX, centerY, p0.getX(), p0.getY());
                double angle1 = Lines.angleToX(centerX, centerY, p1.getX(), p1.getY());
                return Double.compare(angle0, angle1);
            }
        };
    }

    static Comparator<Point2D> byDistanceComparator(final double x, final double y) {
        return new Comparator<Point2D>(){

            @Override
            public int compare(Point2D p0, Point2D p1) {
                double dx0 = p0.getX() - x;
                double dy0 = p0.getY() - y;
                double dx1 = p1.getX() - x;
                double dy1 = p1.getY() - y;
                double d0 = dx0 * dx0 + dy0 * dy0;
                double d1 = dx1 * dx1 + dy1 * dy1;
                return Double.compare(d0, d1);
            }
        };
    }

    static Comparator<Point2D> byDistanceComparator(Point2D reference) {
        return Points.byDistanceComparator(reference.getX(), reference.getY());
    }

    static Comparator<Point2D> byDistanceToOriginComparator() {
        return Points.byDistanceComparator(0.0, 0.0);
    }

    public static Point2D sub(Point2D p0, Point2D p1, Point2D result) {
        if (result == null) {
            result = new Point2D.Double();
        }
        result.setLocation(p0.getX() - p1.getX(), p0.getY() - p1.getY());
        return result;
    }

    public static Point2D add(Point2D p0, Point2D p1, Point2D result) {
        if (result == null) {
            result = new Point2D.Double();
        }
        result.setLocation(p0.getX() + p1.getX(), p0.getY() + p1.getY());
        return result;
    }

    public static Point2D scale(Point2D p0, double factor, Point2D result) {
        if (result == null) {
            result = new Point2D.Double();
        }
        result.setLocation(p0.getX() * factor, p0.getY() * factor);
        return result;
    }

    public static Point2D addScaled(Point2D p0, double factor, Point2D p1, Point2D result) {
        if (result == null) {
            result = new Point2D.Double();
        }
        result.setLocation(p0.getX() + factor * p1.getX(), p0.getY() + factor * p1.getY());
        return result;
    }

    public static Point2D interpolate(Point2D p0, Point2D p1, double alpha, Point2D result) {
        return Points.interpolate(p0.getX(), p0.getY(), p1.getX(), p1.getY(), alpha, result);
    }

    public static Point2D interpolate(double x0, double y0, double x1, double y1, double alpha, Point2D result) {
        if (result == null) {
            result = new Point2D.Double();
        }
        double dx = x1 - x0;
        double dy = y1 - y0;
        result.setLocation(x0 + alpha * dx, y0 + alpha * dy);
        return result;
    }

    public static Point2D inverseTransform(AffineTransform at, Point2D pSrc, Point2D pDst) {
        try {
            return at.inverseTransform(pSrc, pDst);
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("Non-invertible transform", e);
        }
    }

    public static List<Point2D> transform(AffineTransform at, Iterable<? extends Point2D> points) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        for (Point2D point2D : points) {
            Point2D tp = at.transform(point2D, null);
            result.add(tp);
        }
        return result;
    }

    public static Rectangle2D computeBounds(Iterable<? extends Point2D> points) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (Point2D point2D : points) {
            double x = point2D.getX();
            double y = point2D.getY();
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public static String toString(Point2D point) {
        return Points.toString(point, "%f");
    }

    public static String toString(Point2D point, String format) {
        return Points.toString(point, Locale.getDefault(), format);
    }

    public static String toString(Point2D point, Locale locale, String format) {
        String sx = String.format(format, point.getX());
        String sy = String.format(format, point.getY());
        return "(" + sx + "," + sy + ")";
    }

    private Points() {
    }
}

