/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.geom;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class Shapes {
    public static List<Line2D> computeLineSegments(Shape shape, double flatness) {
        ArrayList<Line2D> result = new ArrayList<Line2D>();
        PathIterator pi = shape.getPathIterator(null, flatness);
        double[] coords = new double[6];
        double[] previous = new double[2];
        double[] first = new double[2];
        while (!pi.isDone()) {
            int segment = pi.currentSegment(coords);
            switch (segment) {
                case 0: {
                    previous[0] = coords[0];
                    previous[1] = coords[1];
                    first[0] = coords[0];
                    first[1] = coords[1];
                    break;
                }
                case 4: {
                    result.add(new Line2D.Double(previous[0], previous[1], first[0], first[1]));
                    previous[0] = first[0];
                    previous[1] = first[1];
                    break;
                }
                case 1: {
                    result.add(new Line2D.Double(previous[0], previous[1], coords[0], coords[1]));
                    previous[0] = coords[0];
                    previous[1] = coords[1];
                    break;
                }
                case 2: {
                    throw new AssertionError((Object)"SEG_QUADTO in flattened path!");
                }
                case 3: {
                    throw new AssertionError((Object)"SEG_CUBICTO in flattened path!");
                }
                default: {
                    throw new AssertionError((Object)"Invalid segment in flattened path!");
                }
            }
            pi.next();
        }
        return result;
    }

    public static List<Point2D> computePoints(Shape shape, double flatness, boolean storeOnClose) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        PathIterator pi = shape.getPathIterator(null, flatness);
        double[] coords = new double[6];
        Point2D.Double previousMove = null;
        while (!pi.isDone()) {
            int segment = pi.currentSegment(coords);
            switch (segment) {
                case 0: {
                    result.add(new Point2D.Double(coords[0], coords[1]));
                    if (!storeOnClose) break;
                    previousMove = new Point2D.Double(coords[0], coords[1]);
                    break;
                }
                case 4: {
                    if (!storeOnClose) break;
                    result.add(previousMove);
                    break;
                }
                case 1: {
                    result.add(new Point2D.Double(coords[0], coords[1]));
                    break;
                }
                case 2: {
                    throw new AssertionError((Object)"SEG_QUADTO in flattened path!");
                }
                case 3: {
                    throw new AssertionError((Object)"SEG_CUBICTO in flattened path!");
                }
                default: {
                    throw new AssertionError((Object)"Invalid segment in flattened path!");
                }
            }
            pi.next();
        }
        return result;
    }

    public static Shape interpolate(Shape shape0, Shape shape1, double alpha) {
        Path2D.Double path = new Path2D.Double();
        PathIterator pi0 = shape0.getPathIterator(null);
        PathIterator pi1 = shape1.getPathIterator(null);
        double[] coords0 = new double[6];
        double[] coords1 = new double[6];
        double[] coords = new double[6];
        while (!pi0.isDone()) {
            int segment1;
            if (pi1.isDone()) {
                throw new IllegalArgumentException("Iterator 1 is done, but not iterator 0");
            }
            int segment0 = pi0.currentSegment(coords0);
            if (segment0 != (segment1 = pi1.currentSegment(coords1))) {
                throw new IllegalArgumentException("Incompatible segments: " + segment0 + " vs. " + segment1);
            }
            switch (segment0) {
                case 0: {
                    Shapes.interpolate(coords0, coords1, coords, alpha, 2);
                    ((Path2D)path).moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    Shapes.interpolate(coords0, coords1, coords, alpha, 2);
                    ((Path2D)path).lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    Shapes.interpolate(coords0, coords1, coords, alpha, 4);
                    ((Path2D)path).quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    Shapes.interpolate(coords0, coords1, coords, alpha, 6);
                    ((Path2D)path).curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    path.closePath();
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unknown segment type");
                }
            }
            pi0.next();
            pi1.next();
        }
        if (!pi1.isDone()) {
            throw new IllegalArgumentException("Iterator 0 is done, but not iterator 1");
        }
        return path;
    }

    private static void interpolate(double[] c0, double[] c1, double[] c, double alpha, int n) {
        for (int i = 0; i < n; ++i) {
            c[i] = c0[i] + (c1[i] - c0[i]) * alpha;
        }
    }

    private Shapes() {
    }
}

