/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.geom;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public final class ArrowCreator {
    private double headLength;
    private boolean relativeHeadLength;
    private double minHeadLength;
    private double maxHeadLength;
    private double headWidth;
    private boolean relativeHeadWidth;
    private double minHeadWidth;
    private double maxHeadWidth;
    private double headBasePosition;

    ArrowCreator() {
        this.setRelativeHeadLength(0.2);
        this.setRelativeHeadWidth(0.15);
        this.setHeadBasePosition(0.15);
    }

    public ArrowCreator setAbsoluteHeadLength(double headLength) {
        this.headLength = headLength;
        this.minHeadLength = headLength;
        this.maxHeadLength = headLength;
        this.relativeHeadLength = false;
        return this;
    }

    public ArrowCreator setRelativeHeadLength(double headLength) {
        return this.setRelativeHeadLength(headLength, 0.0, Double.MAX_VALUE);
    }

    public ArrowCreator setRelativeHeadLength(double headLength, double minAbsolute, double maxAbsolute) {
        this.headLength = headLength;
        this.minHeadLength = minAbsolute;
        this.maxHeadLength = maxAbsolute;
        this.relativeHeadLength = true;
        return this;
    }

    public ArrowCreator setAbsoluteHeadWidth(double headWidth) {
        this.headWidth = headWidth;
        this.minHeadWidth = headWidth;
        this.maxHeadWidth = headWidth;
        this.relativeHeadWidth = false;
        return this;
    }

    public ArrowCreator setRelativeHeadWidth(double headWidth) {
        return this.setRelativeHeadWidth(headWidth, 0.0, Double.MAX_VALUE);
    }

    public ArrowCreator setRelativeHeadWidth(double headWidth, double minAbsolute, double maxAbsolute) {
        this.headWidth = headWidth;
        this.minHeadWidth = minAbsolute;
        this.maxHeadWidth = maxAbsolute;
        this.relativeHeadWidth = true;
        return this;
    }

    public ArrowCreator setHeadBasePosition(double headBasePosition) {
        this.headBasePosition = headBasePosition;
        return this;
    }

    private double computeActualHeadLength(double arrowLength) {
        double actualHeadLength = this.headLength;
        if (this.relativeHeadLength) {
            actualHeadLength *= arrowLength;
        }
        actualHeadLength = Math.max(this.minHeadLength, actualHeadLength);
        actualHeadLength = Math.min(this.maxHeadLength, actualHeadLength);
        return actualHeadLength;
    }

    private double computeActualHeadWidth(double arrowLength) {
        double actualHeadWidth = this.headWidth;
        if (this.relativeHeadWidth) {
            actualHeadWidth *= arrowLength;
        }
        actualHeadWidth = Math.max(this.minHeadWidth, actualHeadWidth);
        actualHeadWidth = Math.min(this.maxHeadWidth, actualHeadWidth);
        return actualHeadWidth;
    }

    public Shape buildShape(Line2D line, double shaftWidth) {
        return this.buildShape(line.getY1(), line.getY1(), line.getX2(), line.getY2(), shaftWidth, true);
    }

    public Shape buildShape(Point2D p0, Point2D p1, double shaftWidth) {
        return this.buildShape(p0.getX(), p0.getY(), p1.getX(), p1.getY(), shaftWidth, true);
    }

    public Shape buildShape(double x0, double y0, double x1, double y1, double shaftWidth) {
        return this.buildShape(x0, y0, x1, y1, shaftWidth, true);
    }

    public Shape buildHeadShape(double x0, double y0, double x1, double y1, double shaftWidth) {
        return this.buildShape(x0, y0, x1, y1, shaftWidth, false);
    }

    private Shape buildShape(double x0, double y0, double x1, double y1, double shaftWidth, boolean includeShaft) {
        double dirY;
        double dx = x1 - x0;
        double dy = y1 - y0;
        double length = Math.sqrt(dx * dx + dy * dy);
        double invLength = 1.0 / length;
        double dirX = dx * invLength;
        double perpDirX = dirY = dy * invLength;
        double perpDirY = -dirX;
        double perpDirOffsetX = perpDirX * 0.5;
        double perpDirOffsetY = perpDirY * 0.5;
        double actualHeadLength = this.computeActualHeadLength(length);
        double actualHeadWidth = this.computeActualHeadWidth(length);
        double headTipsX = x1 - actualHeadLength * dirX;
        double headTipsY = y1 - actualHeadLength * dirY;
        double headTipOffsetX = actualHeadWidth * perpDirOffsetX;
        double headTipOffsetY = actualHeadWidth * perpDirOffsetY;
        double headTipLx = headTipsX + headTipOffsetX;
        double headTipLy = headTipsY + headTipOffsetY;
        double headTipRx = headTipsX - headTipOffsetX;
        double headTipRy = headTipsY - headTipOffsetY;
        double headBaseOffsetFromEnd = actualHeadLength * (1.0 - this.headBasePosition);
        double headBaseX = x1 - headBaseOffsetFromEnd * dirX;
        double headBaseY = y1 - headBaseOffsetFromEnd * dirY;
        double shaftWidthOffsetX = shaftWidth * perpDirOffsetX;
        double shaftWidthOffsetY = shaftWidth * perpDirOffsetY;
        double headBaseLx = headBaseX + shaftWidthOffsetX;
        double headBaseLy = headBaseY + shaftWidthOffsetY;
        double headBaseRx = headBaseX - shaftWidthOffsetX;
        double headBaseRy = headBaseY - shaftWidthOffsetY;
        double shaftBaseLx = x0 + shaftWidthOffsetX;
        double shaftBaseLy = y0 + shaftWidthOffsetY;
        double shaftBaseRx = x0 - shaftWidthOffsetX;
        double shaftBaseRy = y0 - shaftWidthOffsetY;
        Path2D.Double p = new Path2D.Double();
        if (includeShaft) {
            ((Path2D)p).moveTo(shaftBaseLx, shaftBaseLy);
            ((Path2D)p).lineTo(headBaseLx, headBaseLy);
        } else {
            ((Path2D)p).moveTo(headBaseLx, headBaseLy);
        }
        ((Path2D)p).lineTo(headBaseLx, headBaseLy);
        ((Path2D)p).lineTo(headTipLx, headTipLy);
        ((Path2D)p).lineTo(x1, y1);
        ((Path2D)p).lineTo(headTipRx, headTipRy);
        ((Path2D)p).lineTo(headBaseRx, headBaseRy);
        if (includeShaft) {
            ((Path2D)p).lineTo(shaftBaseRx, shaftBaseRy);
        }
        p.closePath();
        return p;
    }

    public Shape buildLines(Line2D line) {
        return this.buildLines(line.getY1(), line.getY1(), line.getX2(), line.getY2());
    }

    public Shape buildLines(Point2D p0, Point2D p1) {
        return this.buildLines(p0.getX(), p0.getY(), p1.getX(), p1.getY());
    }

    public Shape buildLines(double x0, double y0, double x1, double y1) {
        double dirY;
        double dx = x1 - x0;
        double dy = y1 - y0;
        double length = Math.sqrt(dx * dx + dy * dy);
        double invLength = 1.0 / length;
        double dirX = dx * invLength;
        double perpDirX = dirY = dy * invLength;
        double perpDirY = -dirX;
        double perpDirOffsetX = perpDirX * 0.5;
        double perpDirOffsetY = perpDirY * 0.5;
        double actualHeadLength = this.computeActualHeadLength(length);
        double actualHeadWidth = this.computeActualHeadWidth(length);
        double headTipsX = x1 - actualHeadLength * dirX;
        double headTipsY = y1 - actualHeadLength * dirY;
        double headTipOffsetX = actualHeadWidth * perpDirOffsetX;
        double headTipOffsetY = actualHeadWidth * perpDirOffsetY;
        double headTipLx = headTipsX + headTipOffsetX;
        double headTipLy = headTipsY + headTipOffsetY;
        double headTipRx = headTipsX - headTipOffsetX;
        double headTipRy = headTipsY - headTipOffsetY;
        Path2D.Double p = new Path2D.Double();
        ((Path2D)p).moveTo(x0, y0);
        ((Path2D)p).lineTo(x1, y1);
        ((Path2D)p).moveTo(headTipLx, headTipLy);
        ((Path2D)p).lineTo(x1, y1);
        ((Path2D)p).moveTo(headTipRx, headTipRy);
        ((Path2D)p).lineTo(x1, y1);
        return p;
    }
}

