/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.geom;

import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Arrays;

class DeltaPathIterator
implements PathIterator {
    private final PathIterator delegate;
    private final double maxDelta;
    private boolean done;
    private final double[] delegateCoords = new double[6];
    private final double[] currentCoords = new double[6];
    private int currentSegment;
    private final Point2D.Double prevDelegateMove = new Point2D.Double();
    private final Point2D.Double prevDelegatePoint = new Point2D.Double();
    private final Point2D.Double nextDelegatePoint = new Point2D.Double();
    private double currentSegmentLength;
    private double currentSegmentDx;
    private double currentSegmentDy;
    private double currentDelta;
    private double currentSegmentPosition;
    private boolean currentSegmentFinished;
    private boolean closeAtEnd;

    DeltaPathIterator(PathIterator delegate, double maxDelta) {
        this.delegate = delegate;
        this.maxDelta = maxDelta;
        this.done = false;
        this.currentSegmentFinished = false;
        this.closeAtEnd = false;
        this.next();
    }

    @Override
    public int getWindingRule() {
        return this.delegate.getWindingRule();
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void next() {
        Arrays.fill(this.currentCoords, 0.0);
        if (this.done) {
            return;
        }
        if (this.currentSegmentFinished) {
            this.closeAtEnd = false;
            if (this.delegate.isDone()) {
                this.done = true;
                return;
            }
            int delegateSegment = this.delegate.currentSegment(this.delegateCoords);
            this.delegate.next();
            if (delegateSegment == 0) {
                this.currentSegment = 0;
                this.currentCoords[0] = this.delegateCoords[0];
                this.currentCoords[1] = this.delegateCoords[1];
                this.prevDelegatePoint.x = this.delegateCoords[0];
                this.prevDelegatePoint.y = this.delegateCoords[1];
                this.nextDelegatePoint.x = this.delegateCoords[0];
                this.nextDelegatePoint.y = this.delegateCoords[1];
                this.prevDelegateMove.x = this.delegateCoords[0];
                this.prevDelegateMove.y = this.delegateCoords[1];
                return;
            }
            if (delegateSegment == 4) {
                this.prevDelegatePoint.x = this.nextDelegatePoint.x;
                this.prevDelegatePoint.y = this.nextDelegatePoint.y;
                this.nextDelegatePoint.x = this.prevDelegateMove.x;
                this.nextDelegatePoint.y = this.prevDelegateMove.y;
                this.closeAtEnd = true;
            } else if (delegateSegment == 1) {
                this.prevDelegatePoint.x = this.nextDelegatePoint.x;
                this.prevDelegatePoint.y = this.nextDelegatePoint.y;
                this.nextDelegatePoint.x = this.delegateCoords[0];
                this.nextDelegatePoint.y = this.delegateCoords[1];
            } else {
                throw new IllegalStateException("Found invalid segment type in flattened path iterator");
            }
            this.currentSegmentLength = this.prevDelegatePoint.distance(this.nextDelegatePoint);
            this.currentDelta = this.maxDelta;
            if (this.currentSegmentLength > (double)1.0E-8f) {
                int steps = (int)Math.ceil(this.currentSegmentLength / this.maxDelta);
                this.currentDelta = this.currentSegmentLength / (double)steps;
            }
            this.currentSegmentDx = this.nextDelegatePoint.x - this.prevDelegatePoint.x;
            this.currentSegmentDy = this.nextDelegatePoint.y - this.prevDelegatePoint.y;
            this.currentSegmentPosition = 0.0;
            this.currentSegmentFinished = false;
        }
        this.currentSegmentPosition += this.currentDelta;
        if (this.currentSegmentPosition >= this.currentSegmentLength - (double)1.0E-8f) {
            this.currentCoords[0] = this.nextDelegatePoint.x;
            this.currentCoords[1] = this.nextDelegatePoint.y;
            this.currentSegment = this.closeAtEnd ? 4 : 1;
            this.currentSegmentFinished = true;
            return;
        }
        double relativeLocation = this.currentSegmentPosition / this.currentSegmentLength;
        double x = this.prevDelegatePoint.x + relativeLocation * this.currentSegmentDx;
        double y = this.prevDelegatePoint.y + relativeLocation * this.currentSegmentDy;
        this.currentCoords[0] = x;
        this.currentCoords[1] = y;
        this.currentSegment = 1;
    }

    @Override
    public int currentSegment(float[] coords) {
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = (float)this.currentCoords[i];
        }
        return this.currentSegment;
    }

    @Override
    public int currentSegment(double[] coords) {
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = this.currentCoords[i];
        }
        return this.currentSegment;
    }
}

