/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.geom;

import de.javagl.geom.AffineTransforms;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class Lines {
    public static double length(Line2D line) {
        return Math.sqrt(Lines.lengthSquared(line));
    }

    public static double lengthSquared(Line2D line) {
        double x0 = line.getX1();
        double y0 = line.getY1();
        double x1 = line.getX2();
        double y1 = line.getY2();
        double dx = x1 - x0;
        double dy = y1 - y0;
        return dx * dx + dy * dy;
    }

    public static Line2D transform(AffineTransform at, Line2D lineSrc, Line2D lineDst) {
        if (lineDst == null) {
            lineDst = new Line2D.Double();
        }
        double sx1 = lineSrc.getX1();
        double sy1 = lineSrc.getY1();
        double sx2 = lineSrc.getX2();
        double sy2 = lineSrc.getY2();
        double dx1 = AffineTransforms.computeX(at, sx1, sy1);
        double dy1 = AffineTransforms.computeY(at, sx1, sy1);
        double dx2 = AffineTransforms.computeX(at, sx2, sy2);
        double dy2 = AffineTransforms.computeY(at, sx2, sy2);
        lineDst.setLine(dx1, dy1, dx2, dy2);
        return lineDst;
    }

    public static Line2D scale(double factor, Line2D lineSrc, Line2D lineDst) {
        if (lineDst == null) {
            lineDst = new Line2D.Double();
        }
        double x0 = lineSrc.getX1();
        double y0 = lineSrc.getY1();
        double x1 = lineSrc.getX2();
        double y1 = lineSrc.getY2();
        double dx = x1 - x0;
        double dy = y1 - y0;
        double newX1 = x0 + dx * factor;
        double newY1 = y0 + dy * factor;
        lineDst.setLine(x0, y0, newX1, newY1);
        return lineDst;
    }

    public static Line2D normalize(Line2D lineSrc, Line2D lineDst) {
        return Lines.scale(1.0 / Lines.length(lineSrc), lineSrc, lineDst);
    }

    public static Line2D scaleToLength(double length, Line2D lineSrc, Line2D lineDst) {
        return Lines.scale(length / Lines.length(lineSrc), lineSrc, lineDst);
    }

    public static Line2D rotate(double angleRad, Line2D lineSrc, Line2D lineDst) {
        double x0 = lineSrc.getX1();
        double y0 = lineSrc.getY1();
        double x1 = lineSrc.getX2();
        double y1 = lineSrc.getY2();
        double dx = x1 - x0;
        double dy = y1 - y0;
        double sa = Math.sin(angleRad);
        double ca = Math.cos(angleRad);
        double nx = ca * dx - sa * dy;
        double ny = sa * dx + ca * dy;
        if (lineDst == null) {
            lineDst = new Line2D.Double();
        }
        lineDst.setLine(x0, y0, x0 + nx, y0 + ny);
        return lineDst;
    }

    public static double angle(Line2D line0, Line2D line1) {
        return Lines.normalizeAngle(Lines.angleToX(line1) - Lines.angleToX(line0));
    }

    public static double angle(Point2D s0, Point2D e0, Point2D s1, Point2D e1) {
        return Lines.normalizeAngle(Lines.angleToX(s1, e1) - Lines.angleToX(s0, e0));
    }

    public static double angle(double sx0, double sy0, double ex0, double ey0, double sx1, double sy1, double ex1, double ey1) {
        return Lines.normalizeAngle(Lines.angleToX(sx1, sy1, ex1, ey1) - Lines.angleToX(sx0, sy0, ex0, ey0));
    }

    public static double angleToX(Line2D line) {
        return Lines.angleToX(line.getX1(), line.getY1(), line.getX2(), line.getY2());
    }

    public static double angleToX(Point2D p0, Point2D p1) {
        return Lines.angleToX(p0.getX(), p0.getY(), p1.getX(), p1.getY());
    }

    public static double angleToX(double x0, double y0, double x1, double y1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        double angleRad = Math.atan2(dy, dx);
        return angleRad;
    }

    static double normalizeAngle(double angle) {
        return (angle + Math.PI + Math.PI) % (Math.PI * 2);
    }

    public static String toString(Line2D line) {
        return Lines.toString(line, "%f");
    }

    public static String toString(Line2D line, String format) {
        String sx1 = String.format(format, line.getX1());
        String sy1 = String.format(format, line.getY1());
        String sx2 = String.format(format, line.getX2());
        String sy2 = String.format(format, line.getY2());
        return "(" + sx1 + "," + sy1 + ")-(" + sx2 + "," + sy2 + ")";
    }

    private Lines() {
    }
}

