/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.geom;

import de.javagl.geom.AffineTransforms;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Rectangles {
    public static Rectangle2D union(Iterable<? extends Rectangle2D> rectangles, Rectangle2D result) {
        if (result == null) {
            result = new Rectangle2D.Double();
        }
        boolean first = true;
        for (Rectangle2D rectangle2D : rectangles) {
            if (first) {
                result.setRect(rectangle2D);
                first = false;
                continue;
            }
            Rectangle2D.union(result, rectangle2D, result);
        }
        return result;
    }

    public static Rectangle2D copy(Rectangle2D r) {
        return new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public static Rectangle2D moveCenterTo(Rectangle2D r, double x, double y, Rectangle2D result) {
        if (result == null) {
            result = new Rectangle2D.Double();
        }
        result.setRect(x - r.getWidth() * 0.5, y - r.getHeight() * 0.5, r.getWidth(), r.getHeight());
        return result;
    }

    public static Rectangle2D translate(Rectangle2D r, double dx, double dy, Rectangle2D result) {
        if (result == null) {
            result = new Rectangle2D.Double();
        }
        result.setRect(r.getX() + dx, r.getY() + dy, r.getWidth(), r.getHeight());
        return result;
    }

    public static Rectangle2D scale(Rectangle2D r, double factor, Rectangle2D result) {
        if (result == null) {
            result = new Rectangle2D.Double();
        }
        double w = factor * r.getWidth();
        double h = factor * r.getHeight();
        result.setRect(r.getCenterX() - w * 0.5, r.getCenterY() - h * 0.5, w, h);
        return r;
    }

    public static Point2D center(Rectangle2D r, Point2D result) {
        if (result == null) {
            result = new Point2D.Double();
        }
        result.setLocation(r.getCenterX(), r.getCenterY());
        return result;
    }

    public static Rectangle2D computeBounds(AffineTransform at, Rectangle2D rSrc, Rectangle2D rDst) {
        double xMin = rSrc.getMinX();
        double yMin = rSrc.getMinY();
        double xMax = rSrc.getMaxX();
        double yMax = rSrc.getMaxY();
        double x0 = AffineTransforms.computeX(at, xMin, yMin);
        double y0 = AffineTransforms.computeY(at, xMin, yMin);
        double x1 = AffineTransforms.computeX(at, xMax, yMin);
        double y1 = AffineTransforms.computeY(at, xMax, yMin);
        double x2 = AffineTransforms.computeX(at, xMax, yMax);
        double y2 = AffineTransforms.computeY(at, xMax, yMax);
        double x3 = AffineTransforms.computeX(at, xMin, yMax);
        double y3 = AffineTransforms.computeY(at, xMin, yMax);
        double minX = Rectangles.min(x0, x1, x2, x3);
        double minY = Rectangles.min(y0, y1, y2, y3);
        double maxX = Rectangles.max(x0, x1, x2, x3);
        double maxY = Rectangles.max(y0, y1, y2, y3);
        if (rDst == null) {
            return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
        }
        rDst.setRect(minX, minY, maxX - minX, maxY - minY);
        return rDst;
    }

    private static double min(double d0, double d1, double d2, double d3) {
        double min = d0;
        if (d1 < min) {
            min = d1;
        }
        if (d2 < min) {
            min = d2;
        }
        if (d3 < min) {
            min = d3;
        }
        return min;
    }

    private static double max(double d0, double d1, double d2, double d3) {
        double max = d0;
        if (d1 > max) {
            max = d1;
        }
        if (d2 > max) {
            max = d2;
        }
        if (d3 > max) {
            max = d3;
        }
        return max;
    }

    public static Point2D getCorner(Rectangle2D rectangle, int index, Point2D pDst) {
        if (pDst == null) {
            pDst = new Point2D.Double();
        }
        int i = Rectangles.positiveRemainder(index, 4);
        switch (i) {
            case 0: {
                pDst.setLocation(rectangle.getMinX(), rectangle.getMinY());
                break;
            }
            case 1: {
                pDst.setLocation(rectangle.getMaxX(), rectangle.getMinY());
                break;
            }
            case 2: {
                pDst.setLocation(rectangle.getMaxX(), rectangle.getMaxY());
                break;
            }
            case 3: {
                pDst.setLocation(rectangle.getMinX(), rectangle.getMaxY());
                break;
            }
        }
        throw new AssertionError((Object)"Remainder must be 0,1,2 or 3");
    }

    private static int positiveRemainder(int value, int d) {
        int result = value % d;
        if (result < 0) {
            return result + d;
        }
        return result;
    }

    private Rectangles() {
    }
}

