/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.geom;

import de.javagl.geom.Points;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class Stars {
    public static Shape createStarShape(double centerX, double centerY, double innerRadius, double outerRadius, int numRays) {
        return Stars.createStarShape(centerX, centerY, innerRadius, outerRadius, numRays, 0.0, 0.0, 0.0);
    }

    public static Shape createStarShape(double centerX, double centerY, double innerRadius, double outerRadius, int numRays, double startAngleRad) {
        return Stars.createStarShape(centerX, centerY, innerRadius, outerRadius, numRays, startAngleRad, 0.0, 0.0);
    }

    public static Shape createStarShape(double centerX, double centerY, double innerRadius, double outerRadius, int numRays, double startAngleRad, double innerRoundness, double outerRoundness) {
        if (numRays < 2) {
            throw new IllegalArgumentException("The number of rays must be at least 2, but is " + numRays);
        }
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        double deltaAngleRad = Math.PI / (double)numRays;
        for (int i = 0; i < numRays * 2; ++i) {
            double angleRad = startAngleRad + (double)i * deltaAngleRad;
            double ca = Math.cos(angleRad);
            double sa = Math.sin(angleRad);
            double relX = ca;
            double relY = sa;
            if ((i & 1) == 0) {
                relX *= outerRadius;
                relY *= outerRadius;
            } else {
                relX *= innerRadius;
                relY *= innerRadius;
            }
            Point2D.Double p = new Point2D.Double(centerX + relX, centerY + relY);
            points.add(p);
        }
        Point2D.Double prevCenter = new Point2D.Double();
        Point2D.Double nextCenter = new Point2D.Double();
        Point2D.Double step0 = new Point2D.Double();
        Point2D.Double step1 = new Point2D.Double();
        Path2D.Double path = new Path2D.Double();
        for (int i = 0; i < numRays * 2; ++i) {
            int iPrev = (i - 1 + points.size()) % points.size();
            int iCurr = i;
            int iNext = (i + 1) % points.size();
            Point2D pPrev = (Point2D)points.get(iPrev);
            Point2D pCurr = (Point2D)points.get(iCurr);
            Point2D pNext = (Point2D)points.get(iNext);
            Points.interpolate(pPrev, pCurr, 0.5, prevCenter);
            Points.interpolate(pCurr, pNext, 0.5, nextCenter);
            if (i == 0) {
                ((Path2D)path).moveTo(((Point2D)prevCenter).getX(), ((Point2D)prevCenter).getY());
            }
            double roundness = innerRoundness;
            if ((i & 1) == 0) {
                roundness = outerRoundness;
            }
            if (Math.abs(roundness) < (double)1.0E-8f) {
                ((Path2D)path).lineTo(pCurr.getX(), pCurr.getY());
                ((Path2D)path).lineTo(((Point2D)nextCenter).getX(), ((Point2D)nextCenter).getY());
                continue;
            }
            if (Math.abs(roundness - 1.0) < (double)1.0E-8f) {
                ((Path2D)path).quadTo(pCurr.getX(), pCurr.getY(), ((Point2D)nextCenter).getX(), ((Point2D)nextCenter).getY());
                continue;
            }
            Points.interpolate(prevCenter, pCurr, 1.0 - roundness, step0);
            Points.interpolate(pCurr, nextCenter, roundness, step1);
            ((Path2D)path).lineTo(((Point2D)step0).getX(), ((Point2D)step0).getY());
            ((Path2D)path).quadTo(pCurr.getX(), pCurr.getY(), ((Point2D)step1).getX(), ((Point2D)step1).getY());
            ((Path2D)path).lineTo(((Point2D)nextCenter).getX(), ((Point2D)nextCenter).getY());
        }
        path.closePath();
        return path;
    }

    private Stars() {
    }
}

