/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.hexagon;

import de.javagl.hexagon.Hexagon;

class DefaultHexagon
implements Hexagon {
    private final double radius;
    private final double sizeX;
    private final double sizeY;
    private final double spacingX;
    private final double spacingY;
    private final double angleStepOffset;

    DefaultHexagon(double radius, boolean horizontal) {
        this.radius = radius;
        if (horizontal) {
            this.sizeY = radius * 2.0;
            this.spacingX = this.sizeX = Math.sqrt(3.0) / 2.0 * this.sizeY;
            this.spacingY = 0.75 * this.sizeY;
            this.angleStepOffset = 0.5;
        } else {
            this.sizeX = radius * 2.0;
            this.sizeY = Math.sqrt(3.0) / 2.0 * this.sizeX;
            this.spacingX = 0.75 * this.sizeX;
            this.spacingY = this.sizeY;
            this.angleStepOffset = 0.0;
        }
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public double getSizeX() {
        return this.sizeX;
    }

    @Override
    public double getSizeY() {
        return this.sizeY;
    }

    @Override
    public double getSpacingX() {
        return this.spacingX;
    }

    @Override
    public double getSpacingY() {
        return this.spacingY;
    }

    @Override
    public double getCornerX(int index) {
        double angleRad = 1.0471975511965976 * ((double)index + this.angleStepOffset);
        double x = Math.cos(angleRad);
        return x * this.radius;
    }

    @Override
    public double getCornerY(int index) {
        double angleRad = 1.0471975511965976 * ((double)index + this.angleStepOffset);
        double y = Math.sin(angleRad);
        return y * this.radius;
    }
}

