/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.hexagon;

import de.javagl.hexagon.HexagonGrid;
import de.javagl.hexagon.Hexagons;
import de.javagl.hexagon.HorizontalEvenShiftedHexagonGrid;
import de.javagl.hexagon.HorizontalOddShiftedHexagonGrid;
import de.javagl.hexagon.VerticalEvenShiftedHexagonGrid;
import de.javagl.hexagon.VerticalOddShiftedHexagonGrid;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class HexagonGrids {
    public static HexagonGrid create(double radius, boolean vertical, boolean evenShifted) {
        if (vertical) {
            if (evenShifted) {
                return new VerticalEvenShiftedHexagonGrid(radius);
            }
            return new VerticalOddShiftedHexagonGrid(radius);
        }
        if (evenShifted) {
            return new HorizontalEvenShiftedHexagonGrid(radius);
        }
        return new HorizontalOddShiftedHexagonGrid(radius);
    }

    public static Rectangle2D computeBounds(HexagonGrid hexagonGrid, int x0, int y0, int x1, int y1, Rectangle2D bounds) {
        Rectangle2D.Double r = new Rectangle2D.Double();
        Point2D.Double center = new Point2D.Double();
        hexagonGrid.getCenter(x0, y0, center);
        Hexagons.computeBounds(hexagonGrid.getHexagon(), center, r);
        if (bounds == null) {
            bounds = new Rectangle2D.Double();
        }
        bounds.setRect(r);
        hexagonGrid.getCenter(x1, y1, center);
        Hexagons.computeBounds(hexagonGrid.getHexagon(), center, r);
        Rectangle2D.union(r, bounds, bounds);
        if (x0 + 1 < x1 - 1) {
            hexagonGrid.getCenter(x0 + 1, y0, center);
            Hexagons.computeBounds(hexagonGrid.getHexagon(), center, r);
            Rectangle2D.union(r, bounds, bounds);
        }
        if (x1 - 1 > x0 + 1) {
            hexagonGrid.getCenter(x1 - 1, y1, center);
            Hexagons.computeBounds(hexagonGrid.getHexagon(), center, r);
            Rectangle2D.union(r, bounds, bounds);
        }
        if (y0 + 1 < y1 - 1) {
            hexagonGrid.getCenter(x0, y0 + 1, center);
            Hexagons.computeBounds(hexagonGrid.getHexagon(), center, r);
            Rectangle2D.union(r, bounds, bounds);
        }
        if (y1 - 1 > y0 + 1) {
            hexagonGrid.getCenter(x1, y1 - 1, center);
            Hexagons.computeBounds(hexagonGrid.getHexagon(), center, r);
            Rectangle2D.union(r, bounds, bounds);
        }
        return bounds;
    }

    private HexagonGrids() {
    }
}

