/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.hexagon;

import de.javagl.hexagon.DefaultHexagon;
import de.javagl.hexagon.Hexagon;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class Hexagons {
    static final Point2D ORIGIN = new Point2D.Double();
    static final double ANGLE_STEP_RAD = 1.0471975511965976;

    static Hexagon createVertical(double radius) {
        return new DefaultHexagon(radius, false);
    }

    static Hexagon createHorizontal(double radius) {
        return new DefaultHexagon(radius, true);
    }

    public static Shape createShape(Hexagon hexagon) {
        return Hexagons.createShape(hexagon, ORIGIN);
    }

    public static Shape createShape(Hexagon hexagon, Point2D center) {
        Path2D.Double p = new Path2D.Double();
        for (int i = 0; i < 6; ++i) {
            double x = hexagon.getCornerX(i) + center.getX();
            double y = hexagon.getCornerY(i) + center.getY();
            if (i == 0) {
                ((Path2D)p).moveTo(x, y);
                continue;
            }
            ((Path2D)p).lineTo(x, y);
        }
        p.closePath();
        return p;
    }

    static List<Point2D> createCorners(Hexagon hexagon, Point2D center) {
        ArrayList<Point2D> corners = new ArrayList<Point2D>(6);
        for (int i = 0; i < 6; ++i) {
            double x = hexagon.getCornerX(i) + center.getX();
            double y = hexagon.getCornerY(i) + center.getY();
            corners.add(new Point2D.Double(x, y));
        }
        return corners;
    }

    static Rectangle2D computeBounds(Hexagon hexagon, Point2D center, Rectangle2D bounds) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (int i = 0; i < 6; ++i) {
            double x = hexagon.getCornerX(i) + center.getX();
            double y = hexagon.getCornerY(i) + center.getY();
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
        }
        if (bounds == null) {
            bounds = new Rectangle2D.Double();
        }
        bounds.setRect(minX, minY, maxX - minX, maxY - minY);
        return bounds;
    }

    private Hexagons() {
    }
}

