/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.hexagon;

import de.javagl.hexagon.Hexagon;
import de.javagl.hexagon.HexagonGrid;
import de.javagl.hexagon.Hexagons;
import java.awt.Point;
import java.awt.geom.Point2D;

class HorizontalEvenShiftedHexagonGrid
implements HexagonGrid {
    private static final int[][][] NEIGHBORS = new int[][][]{new int[][]{{1, 0}, {1, -1}, {0, -1}, {-1, 0}, {0, 1}, {1, 1}}, new int[][]{{1, 0}, {0, -1}, {-1, -1}, {-1, 0}, {-1, 1}, {0, 1}}};
    private final Hexagon hexagon;

    HorizontalEvenShiftedHexagonGrid(double radius) {
        this.hexagon = Hexagons.createHorizontal(radius);
    }

    @Override
    public Hexagon getHexagon() {
        return this.hexagon;
    }

    @Override
    public Point2D getCenter(int x, int y, Point2D p) {
        boolean oddY;
        Hexagon hexagon = this.getHexagon();
        double cx = (double)x * hexagon.getSpacingX();
        double cy = (double)y * hexagon.getSpacingY();
        boolean bl = oddY = (y & 1) == 1;
        if (!oddY) {
            cx += 0.5 * hexagon.getSizeX();
        }
        if (p == null) {
            p = new Point2D.Double(cx, cy);
        } else {
            p.setLocation(cx, cy);
        }
        return p;
    }

    @Override
    public Point getNeighbor(int x, int y, int direction, Point p) {
        if (direction < 0 || direction > 6) {
            throw new IllegalArgumentException("Direction must be in [0,6), but is " + direction);
        }
        int parity = y & 1;
        int[] d = NEIGHBORS[parity][direction];
        if (p == null) {
            p = new Point();
        }
        p.x = x + d[0];
        p.y = y + d[1];
        return p;
    }

    @Override
    public Point convertOffsetToCubeCoordinates(int ox, int oy, Point p) {
        int cx = ox - (oy + (oy & 1)) / 2;
        int cz = oy;
        int cy = -cx - cz;
        if (p == null) {
            p = new Point();
        }
        p.x = cx;
        p.y = cy;
        return p;
    }

    @Override
    public Point convertCubeToOffsetCoordinates(int cx, int cy, Point p) {
        int cz = -cx - cy;
        int ox = cx + (cz + (cz & 1)) / 2;
        int oy = cz;
        if (p == null) {
            p = new Point();
        }
        p.x = ox;
        p.y = oy;
        return p;
    }

    @Override
    public int computeStepsDistance(int x0, int y0, int x1, int y1) {
        int cx0 = x0 - (y0 + (y0 & 1)) / 2;
        int cz0 = y0;
        int cy0 = -cx0 - cz0;
        int cx1 = x1 - (y1 + (y1 & 1)) / 2;
        int cz1 = y1;
        int cy1 = -cx1 - cz1;
        int dx = Math.abs(cx0 - cx1);
        int dy = Math.abs(cy0 - cy1);
        int dz = Math.abs(cz0 - cz1);
        return Math.max(dx, Math.max(dy, dz));
    }

    @Override
    public double computeSquaredCentersDistance(int x0, int y0, int x1, int y1) {
        boolean oddY1;
        boolean oddY0;
        Hexagon hexagon = this.getHexagon();
        double cx0 = (double)x0 * hexagon.getSpacingX();
        double cy0 = (double)y0 * hexagon.getSpacingY();
        boolean bl = oddY0 = (y0 & 1) == 1;
        if (!oddY0) {
            cx0 += 0.5 * hexagon.getSizeX();
        }
        double cx1 = (double)x1 * hexagon.getSpacingX();
        double cy1 = (double)y1 * hexagon.getSpacingY();
        boolean bl2 = oddY1 = (y1 & 1) == 1;
        if (!oddY1) {
            cx1 += 0.5 * hexagon.getSizeX();
        }
        double dx = cx1 - cx0;
        double dy = cy1 - cy0;
        return dx * dx + dy * dy;
    }
}

