/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.obj;

import java.nio.FloatBuffer;
import java.util.logging.Logger;

public class ObjNormals {
    private static final Logger logger = Logger.getLogger(ObjNormals.class.getName());
    private static final double EPSILON = 1.0E-6;

    public static void normalize(FloatBuffer normals) {
        int numZeroLengthNormals = 0;
        int n = normals.capacity() / 3;
        for (int i = 0; i < n; ++i) {
            float x = normals.get(i * 3 + 0);
            float y = normals.get(i * 3 + 1);
            float z = normals.get(i * 3 + 2);
            double length = Math.sqrt(x * x + y * y + z * z);
            float nx = 1.0f;
            float ny = 0.0f;
            float nz = 0.0f;
            if (length < 1.0E-6) {
                ++numZeroLengthNormals;
            } else {
                float invLength = (float)(1.0 / length);
                nx = x * invLength;
                ny = y * invLength;
                nz = z * invLength;
            }
            normals.put(i * 3 + 0, nx);
            normals.put(i * 3 + 1, ny);
            normals.put(i * 3 + 2, nz);
        }
        if (numZeroLengthNormals > 0) {
            logger.warning("There have been " + numZeroLengthNormals + " normals with zero length. Using (1,0,0) as a default.");
        }
    }

    private ObjNormals() {
    }
}

