/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.obj.model;

import de.javagl.jgltf.model.ImageModel;
import de.javagl.jgltf.model.TextureModel;
import de.javagl.jgltf.model.creation.ImageModels;
import de.javagl.jgltf.model.impl.DefaultImageModel;
import de.javagl.jgltf.model.impl.DefaultTextureModel;
import de.javagl.jgltf.model.io.IO;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class TextureModelHandler {
    private static final Logger logger = Logger.getLogger(TextureModelHandler.class.getName());
    private final String baseUri;
    private final Map<String, TextureModel> imageUriToTextureModel;

    TextureModelHandler(String baseUri) {
        this.baseUri = baseUri;
        this.imageUriToTextureModel = new LinkedHashMap<String, TextureModel>();
    }

    TextureModel getTextureModel(String imageUri) {
        TextureModel textureModel = this.imageUriToTextureModel.get(imageUri);
        if (textureModel != null) {
            return textureModel;
        }
        String inputUri = null;
        try {
            inputUri = IO.makeAbsolute((URI)URI.create(this.baseUri), (String)imageUri).toString();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            return null;
        }
        DefaultImageModel imageModel = ImageModels.create((String)inputUri, (String)imageUri);
        DefaultTextureModel newTextureModel = new DefaultTextureModel();
        newTextureModel.setImageModel((ImageModel)imageModel);
        this.imageUriToTextureModel.put(imageUri, (TextureModel)newTextureModel);
        return newTextureModel;
    }

    List<TextureModel> getTextureModels() {
        return new ArrayList<TextureModel>(this.imageUriToTextureModel.values());
    }
}

