/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.obj.model;

import de.javagl.jgltf.model.MaterialModel;
import de.javagl.jgltf.model.TextureModel;
import de.javagl.jgltf.model.v1.MaterialModelV1;
import de.javagl.jgltf.obj.model.MtlMaterialHandler;
import de.javagl.jgltf.obj.model.MtlMaterialValues;
import de.javagl.jgltf.obj.model.ObjTechniqueModels;
import de.javagl.jgltf.obj.model.TextureModelHandler;
import de.javagl.obj.Mtl;
import de.javagl.obj.ReadableObj;
import java.util.Map;

class MtlMaterialHandlerV1
implements MtlMaterialHandler {
    private final TextureModelHandler textureModelHandler;

    MtlMaterialHandlerV1(String baseUri) {
        this.textureModelHandler = new TextureModelHandler(baseUri);
    }

    @Override
    public MaterialModel createMaterial(ReadableObj obj, Mtl mtl) {
        boolean withNormals;
        boolean withTexture = obj.getNumTexCoords() > 0 && mtl != null && mtl.getMapKd() != null;
        boolean bl = withNormals = obj.getNumNormals() > 0;
        if (withTexture) {
            return this.createMaterialWithTexture(withNormals, mtl);
        }
        return this.createMaterialWithColor(withNormals, 0.75f, 0.75f, 0.75f);
    }

    private MaterialModel createMaterialWithTexture(boolean withNormals, Mtl mtl) {
        MaterialModelV1 materialModelV1 = new MaterialModelV1();
        if (withNormals) {
            materialModelV1.setTechniqueModel(ObjTechniqueModels.TECHNIQUE_MODEL_TEXTURE_NORMALS);
        } else {
            materialModelV1.setTechniqueModel(ObjTechniqueModels.TECHNIQUE_MODEL_TEXTURE);
        }
        String imageUri = mtl.getMapKd();
        TextureModel textureModel = this.textureModelHandler.getTextureModel(imageUri);
        Map<String, Object> materialValues = MtlMaterialValues.createMaterialValues(mtl, textureModel);
        materialModelV1.setValues(materialValues);
        return materialModelV1;
    }

    @Override
    public MaterialModel createMaterialWithColor(boolean withNormals, float r, float g, float b) {
        MaterialModelV1 materialModelV1 = new MaterialModelV1();
        if (withNormals) {
            materialModelV1.setTechniqueModel(ObjTechniqueModels.TECHNIQUE_MODEL_NORMALS);
        } else {
            materialModelV1.setTechniqueModel(ObjTechniqueModels.TECHNIQUE_MODEL_NONE);
        }
        materialModelV1.setValues(MtlMaterialValues.createDefaultMaterialValues(r, g, b));
        return materialModelV1;
    }
}

