/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.obj.model;

import de.javagl.jgltf.model.GltfConstants;
import de.javagl.jgltf.model.GltfModel;
import de.javagl.jgltf.model.MaterialModel;
import de.javagl.jgltf.model.MeshModel;
import de.javagl.jgltf.model.MeshPrimitiveModel;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.SceneModel;
import de.javagl.jgltf.model.creation.GltfModelBuilder;
import de.javagl.jgltf.model.creation.MeshPrimitiveBuilder;
import de.javagl.jgltf.model.impl.DefaultMeshModel;
import de.javagl.jgltf.model.impl.DefaultMeshPrimitiveModel;
import de.javagl.jgltf.model.impl.DefaultNodeModel;
import de.javagl.jgltf.model.impl.DefaultSceneModel;
import de.javagl.jgltf.model.io.IO;
import de.javagl.jgltf.obj.ObjNormals;
import de.javagl.jgltf.obj.model.MtlMaterialHandler;
import de.javagl.jgltf.obj.model.MtlMaterialHandlerV1;
import de.javagl.jgltf.obj.model.MtlMaterialHandlerV2;
import de.javagl.obj.Mtl;
import de.javagl.obj.MtlReader;
import de.javagl.obj.Obj;
import de.javagl.obj.ObjData;
import de.javagl.obj.ObjGroup;
import de.javagl.obj.ObjReader;
import de.javagl.obj.ObjSplitting;
import de.javagl.obj.ObjUtils;
import de.javagl.obj.ReadableObj;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjGltfModelCreator {
    private static final Logger logger = Logger.getLogger(ObjGltfModelCreator.class.getName());
    private static final Level level = Level.INFO;
    private MtlMaterialHandler mtlMaterialHandler;
    private int indicesComponentType = 5123;
    private Function<? super ReadableObj, List<? extends ReadableObj>> objSplitter;
    private boolean assigningRandomColorsToParts = false;
    private boolean techniqueBasedMaterials = false;
    private boolean oneMeshPerPrimitive = false;

    public ObjGltfModelCreator() {
        this.setIndicesComponentType(5123);
    }

    public void setTechniqueBasedMaterials(boolean techniqueBasedMaterials) {
        this.techniqueBasedMaterials = techniqueBasedMaterials;
    }

    public void setIndicesComponentType(int indicesComponentType) {
        List<Integer> validTypes = Arrays.asList(5121, 5123, 5125);
        if (!validTypes.contains(indicesComponentType)) {
            throw new IllegalArgumentException("The indices component type must be GL_UNSIGNED_BYTE,GL_UNSIGNED_SHORT or GL_UNSIGNED_INT, but is " + GltfConstants.stringFor((int)indicesComponentType));
        }
        this.indicesComponentType = indicesComponentType;
        if (indicesComponentType == 5125) {
            this.objSplitter = obj -> Collections.singletonList(obj);
        } else if (indicesComponentType == 5123) {
            int maxNumVertices = 65533;
            this.objSplitter = obj -> ObjSplitting.splitByMaxNumVertices((ReadableObj)obj, (int)maxNumVertices);
        } else if (indicesComponentType == 5121) {
            int maxNumVertices = 253;
            this.objSplitter = obj -> ObjSplitting.splitByMaxNumVertices((ReadableObj)obj, (int)maxNumVertices);
        }
    }

    public void setAssigningRandomColorsToParts(boolean assigningRandomColorsToParts) {
        this.assigningRandomColorsToParts = assigningRandomColorsToParts;
    }

    public void setOneMeshPerPrimitive(boolean oneMeshPerPrimitive) {
        this.oneMeshPerPrimitive = oneMeshPerPrimitive;
    }

    public GltfModel create(URI objUri) throws IOException {
        logger.log(level, "Creating glTF");
        logger.log(level, "Resolving paths from " + objUri);
        URI baseUri = IO.getParent((URI)objUri);
        String objFileName = IO.extractFileName((URI)objUri);
        String baseName = ObjGltfModelCreator.stripFileNameExtension(objFileName);
        this.mtlMaterialHandler = this.techniqueBasedMaterials ? new MtlMaterialHandlerV1(baseUri.toString()) : new MtlMaterialHandlerV2(baseUri.toString());
        Obj obj = ObjGltfModelCreator.readObj(objUri);
        ArrayList<String> mtlFileNames = new ArrayList<String>(obj.getMtlFileNames());
        if (mtlFileNames.isEmpty()) {
            String mtlFileName = baseName + ".mtl";
            logger.log(level, "Using default MTL file name " + mtlFileName);
            mtlFileNames.add(mtlFileName);
        }
        LinkedHashMap<String, Mtl> mtls = new LinkedHashMap<String, Mtl>();
        for (String mtlFileName : mtlFileNames) {
            URI mtlUri = IO.makeAbsolute((URI)baseUri, (String)mtlFileName);
            if (!IO.existsUnchecked((URI)mtlUri)) continue;
            Map<String, Mtl> fileMtls = ObjGltfModelCreator.readMtls(mtlUri);
            mtls.putAll(fileMtls);
        }
        return this.convert((ReadableObj)obj, mtls, baseName, baseUri);
    }

    private static Obj readObj(URI objUri) throws IOException {
        logger.log(level, "Reading OBJ from " + objUri);
        try (InputStream objInputStream = objUri.toURL().openStream();){
            Obj obj = ObjReader.read((InputStream)objInputStream);
            Obj obj2 = ObjUtils.convertToRenderable((ReadableObj)obj);
            return obj2;
        }
    }

    private static Map<String, Mtl> readMtls(URI mtlUri) throws IOException {
        logger.log(level, "Reading MTL from " + mtlUri);
        try (InputStream mtlInputStream = mtlUri.toURL().openStream();){
            Map mtls;
            List mtlList = MtlReader.read((InputStream)mtlInputStream);
            Map map2 = mtls = (Map)mtlList.stream().collect(LinkedHashMap::new, (map, mtl) -> map.put(mtl.getName(), mtl), (map0, map1) -> map0.putAll(map1));
            return map2;
        }
    }

    GltfModel convert(ReadableObj obj, Map<String, Mtl> mtlsMap, String baseName, URI baseUri) {
        Map mtls = Optionals.of(mtlsMap);
        List<DefaultMeshPrimitiveModel> meshPrimitives = this.createMeshPrimitives(obj, mtls);
        DefaultSceneModel scene = new DefaultSceneModel();
        if (this.oneMeshPerPrimitive) {
            for (MeshPrimitiveModel meshPrimitiveModel : meshPrimitives) {
                DefaultMeshModel defaultMeshModel = new DefaultMeshModel();
                defaultMeshModel.addMeshPrimitiveModel(meshPrimitiveModel);
                DefaultNodeModel node = new DefaultNodeModel();
                node.addMeshModel((MeshModel)defaultMeshModel);
                scene.addNode((NodeModel)node);
            }
        } else {
            DefaultMeshModel mesh = new DefaultMeshModel();
            for (MeshPrimitiveModel meshPrimitiveModel : meshPrimitives) {
                mesh.addMeshPrimitiveModel(meshPrimitiveModel);
            }
            DefaultNodeModel defaultNodeModel = new DefaultNodeModel();
            defaultNodeModel.addMeshModel((MeshModel)mesh);
            scene.addNode((NodeModel)defaultNodeModel);
        }
        GltfModelBuilder gltfModelBuilder = GltfModelBuilder.create();
        gltfModelBuilder.addSceneModel((SceneModel)scene);
        if (this.techniqueBasedMaterials) {
            return gltfModelBuilder.buildV1();
        }
        return gltfModelBuilder.build();
    }

    private List<DefaultMeshPrimitiveModel> createMeshPrimitives(ReadableObj obj, Map<String, Mtl> mtls) {
        int numMaterialGroups = obj.getNumMaterialGroups();
        if (numMaterialGroups == 0 || mtls.isEmpty()) {
            return this.createMeshPrimitives(obj);
        }
        ArrayList<DefaultMeshPrimitiveModel> meshPrimitives = new ArrayList<DefaultMeshPrimitiveModel>();
        for (int i = 0; i < numMaterialGroups; ++i) {
            ObjGroup materialGroup = obj.getMaterialGroup(i);
            String materialGroupName = materialGroup.getName();
            Obj materialObj = ObjUtils.groupToObj((ReadableObj)obj, (ObjGroup)materialGroup, null);
            Mtl mtl = mtls.get(materialGroupName);
            logger.log(level, "Creating MeshPrimitive for material " + materialGroupName);
            List<DefaultMeshPrimitiveModel> subMeshPrimitives = this.createPartMeshPrimitives((ReadableObj)materialObj);
            this.assignMaterial(subMeshPrimitives, obj, mtl);
            meshPrimitives.addAll(subMeshPrimitives);
        }
        return meshPrimitives;
    }

    private List<DefaultMeshPrimitiveModel> createMeshPrimitives(ReadableObj obj) {
        boolean withNormals;
        logger.log(level, "Creating MeshPrimitives for OBJ");
        List<DefaultMeshPrimitiveModel> meshPrimitives = this.createPartMeshPrimitives(obj);
        boolean bl = withNormals = obj.getNumNormals() > 0;
        if (this.assigningRandomColorsToParts) {
            this.assignRandomColorMaterials(meshPrimitives, withNormals);
        } else {
            this.assignDefaultMaterial(meshPrimitives, withNormals);
        }
        return meshPrimitives;
    }

    private void assignMaterial(Iterable<? extends DefaultMeshPrimitiveModel> meshPrimitives, ReadableObj obj, Mtl mtl) {
        MaterialModel material = this.mtlMaterialHandler.createMaterial(obj, mtl);
        for (DefaultMeshPrimitiveModel defaultMeshPrimitiveModel : meshPrimitives) {
            defaultMeshPrimitiveModel.setMaterialModel(material);
        }
    }

    private void assignDefaultMaterial(Iterable<? extends DefaultMeshPrimitiveModel> meshPrimitives, boolean withNormals) {
        MaterialModel material = this.mtlMaterialHandler.createMaterialWithColor(withNormals, 0.75f, 0.75f, 0.75f);
        for (DefaultMeshPrimitiveModel defaultMeshPrimitiveModel : meshPrimitives) {
            defaultMeshPrimitiveModel.setMaterialModel(material);
        }
    }

    private void assignRandomColorMaterials(Iterable<? extends DefaultMeshPrimitiveModel> meshPrimitives, boolean withNormals) {
        Random random = new Random(0L);
        for (DefaultMeshPrimitiveModel defaultMeshPrimitiveModel : meshPrimitives) {
            float r = random.nextFloat();
            float g = random.nextFloat();
            float b = random.nextFloat();
            MaterialModel material = this.mtlMaterialHandler.createMaterialWithColor(withNormals, r, g, b);
            defaultMeshPrimitiveModel.setMaterialModel(material);
        }
    }

    private List<DefaultMeshPrimitiveModel> createPartMeshPrimitives(ReadableObj obj) {
        List<? extends ReadableObj> parts = this.objSplitter.apply((ReadableObj)obj);
        MeshPrimitiveBuilder meshPrimitiveBuilder = MeshPrimitiveBuilder.create();
        ArrayList<DefaultMeshPrimitiveModel> meshPrimitives = new ArrayList<DefaultMeshPrimitiveModel>();
        for (int i = 0; i < parts.size(); ++i) {
            ReadableObj part = parts.get(i);
            DefaultMeshPrimitiveModel meshPrimitive = this.createMeshPrimitive(meshPrimitiveBuilder, part);
            meshPrimitives.add(meshPrimitive);
        }
        return meshPrimitives;
    }

    private DefaultMeshPrimitiveModel createMeshPrimitive(MeshPrimitiveBuilder meshPrimitiveBuilder, ReadableObj part) {
        FloatBuffer objNormals;
        meshPrimitiveBuilder.setTriangles();
        int numVerticesPerFace = 3;
        IntBuffer objIndices = ObjData.getFaceVertexIndices((ReadableObj)part, (int)numVerticesPerFace);
        meshPrimitiveBuilder.setIndicesAs(objIndices, this.indicesComponentType);
        FloatBuffer objVertices = ObjData.getVertices((ReadableObj)part);
        meshPrimitiveBuilder.addPositions3D(objVertices);
        boolean flipY = true;
        FloatBuffer objTexCoords = ObjData.getTexCoords((ReadableObj)part, (int)2, (boolean)flipY);
        if (objTexCoords.capacity() > 0) {
            meshPrimitiveBuilder.addTexCoords02D(objTexCoords);
        }
        if ((objNormals = ObjData.getNormals((ReadableObj)part)).capacity() > 0) {
            ObjNormals.normalize(objNormals);
            meshPrimitiveBuilder.addNormals3D(objNormals);
        }
        return meshPrimitiveBuilder.build();
    }

    private static String stripFileNameExtension(String fileName) {
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return fileName;
        }
        return fileName.substring(0, lastDotIndex);
    }
}

