/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.BufferViewModel;
import de.javagl.jgltf.model.CameraModel;
import de.javagl.jgltf.model.GltfModel;
import de.javagl.jgltf.model.MaterialModel;
import de.javagl.jgltf.model.MeshModel;
import de.javagl.jgltf.model.MeshPrimitiveModel;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.SceneModel;
import de.javagl.jgltf.model.TextureModel;
import de.javagl.jgltf.model.gl.ProgramModel;
import de.javagl.jgltf.model.gl.TechniqueModel;
import de.javagl.jgltf.model.gl.TechniqueParametersModel;
import de.javagl.jgltf.model.gl.TechniqueStatesFunctionsModel;
import de.javagl.jgltf.model.gl.TechniqueStatesModel;
import de.javagl.jgltf.viewer.GlContext;
import de.javagl.jgltf.viewer.GltfRenderData;
import de.javagl.jgltf.viewer.Morphing;
import de.javagl.jgltf.viewer.RenderCommandUtils;
import de.javagl.jgltf.viewer.RenderedGltfModel;
import de.javagl.jgltf.viewer.UniformGetterFactory;
import de.javagl.jgltf.viewer.UniformSetterFactory;
import de.javagl.jgltf.viewer.ViewConfiguration;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;

class DefaultRenderedGltfModel
implements RenderedGltfModel {
    private static final Logger logger = Logger.getLogger(DefaultRenderedGltfModel.class.getName());
    private final GlContext glContext;
    private final ViewConfiguration viewConfiguration;
    private final GltfRenderData gltfRenderData;
    private final UniformGetterFactory uniformGetterFactory;
    private final UniformSetterFactory uniformSetterFactory;
    private final Function<Object, ? extends TextureModel> textureModelLookup;
    private final List<Runnable> opaqueRenderCommands;
    private final List<Runnable> transparentRenderCommands;

    public DefaultRenderedGltfModel(GlContext glContext, GltfModel gltfModel, Function<Object, ? extends TextureModel> textureModelLookup, ViewConfiguration viewConfiguration) {
        Objects.requireNonNull(gltfModel, "The gltfModel may not be null");
        this.textureModelLookup = Objects.requireNonNull(textureModelLookup, "The textureModelLookup may not be null");
        this.glContext = glContext;
        this.viewConfiguration = Objects.requireNonNull(viewConfiguration, "The viewConfiguration may not be null");
        this.gltfRenderData = new GltfRenderData(glContext);
        this.uniformGetterFactory = new UniformGetterFactory(viewConfiguration::getViewport, viewConfiguration::getViewMatrix, viewConfiguration::getProjectionMatrix);
        this.uniformSetterFactory = new UniformSetterFactory(glContext);
        this.opaqueRenderCommands = new ArrayList<Runnable>();
        this.transparentRenderCommands = new ArrayList<Runnable>();
        logger.fine("Processing scenes...");
        Optionals.of((List)gltfModel.getSceneModels()).forEach(this::processSceneModel);
        logger.fine("Processing scenes DONE...");
    }

    @Override
    public void delete() {
        this.gltfRenderData.delete();
        this.opaqueRenderCommands.clear();
        this.transparentRenderCommands.clear();
        this.opaqueRenderCommands.add(() -> logger.warning("Rendered object has been deleted"));
    }

    @Override
    public void render() {
        for (Runnable renderCommand : this.opaqueRenderCommands) {
            renderCommand.run();
        }
        for (Runnable renderCommand : this.transparentRenderCommands) {
            renderCommand.run();
        }
    }

    @Override
    public void setCurrentCameraModel(CameraModel cameraModel) {
        this.viewConfiguration.setCurrentCameraModel(cameraModel);
    }

    private void processSceneModel(SceneModel sceneModel) {
        logger.fine("Processing scene " + sceneModel);
        List nodeModels = sceneModel.getNodeModels();
        for (NodeModel nodeModel : nodeModels) {
            this.processNodeModel(nodeModel);
        }
        logger.fine("Processing scene " + sceneModel + " DONE");
    }

    private void processNodeModel(NodeModel nodeModel) {
        logger.fine("Processing node " + nodeModel);
        List meshModels = nodeModel.getMeshModels();
        for (MeshModel meshModel : meshModels) {
            List primitives = meshModel.getMeshPrimitiveModels();
            for (int i = 0; i < primitives.size(); ++i) {
                MeshPrimitiveModel meshPrimitiveModel = (MeshPrimitiveModel)primitives.get(i);
                this.processMeshPrimitiveModel(nodeModel, meshModel, meshPrimitiveModel);
            }
        }
        List children = nodeModel.getChildren();
        for (NodeModel childNode : children) {
            this.processNodeModel(childNode);
        }
        logger.fine("Processing node " + nodeModel + " DONE");
    }

    private void processMeshPrimitiveModel(NodeModel nodeModel, MeshModel meshModel, MeshPrimitiveModel meshPrimitiveModel) {
        boolean isOpaque;
        logger.fine("Processing meshPrimitive...");
        MaterialModel materialModel = meshPrimitiveModel.getMaterialModel();
        TechniqueModel techniqueModel = materialModel.getTechniqueModel();
        ProgramModel programModel = techniqueModel.getProgramModel();
        Integer glProgram = this.gltfRenderData.obtainGlProgram(programModel);
        if (glProgram == null) {
            logger.warning("No GL program found for program " + programModel + " in technique " + techniqueModel);
            return;
        }
        int glVertexArray = this.glContext.createGlVertexArray();
        this.gltfRenderData.addGlVertexArray(glVertexArray);
        List<Runnable> attributeUpdateCommands = this.createAttributes(glVertexArray, nodeModel, meshModel, meshPrimitiveModel);
        final ArrayList<Runnable> commands = new ArrayList<Runnable>();
        commands.add(() -> this.glContext.useGlProgram(glProgram));
        List<Runnable> uniformSettingCommands = this.createUniformSettingCommands(materialModel, nodeModel, glProgram);
        commands.addAll(uniformSettingCommands);
        commands.add(() -> this.glContext.disable(TechniqueStatesModel.getAllStates()));
        TechniqueStatesModel techniqueStatesModel = techniqueModel.getTechniqueStatesModel();
        List enabledStates = techniqueStatesModel.getEnable();
        commands.add(() -> this.glContext.enable(enabledStates));
        TechniqueStatesFunctionsModel techniqueStatesFunctionsModel = techniqueStatesModel.getTechniqueStatesFunctionsModel();
        commands.addAll(DefaultRenderedGltfModel.createTechniqueStatesFunctionsSettingCommands(this.glContext, techniqueStatesFunctionsModel));
        commands.addAll(attributeUpdateCommands);
        Runnable renderCommand = this.createRenderCommand(meshPrimitiveModel, glVertexArray);
        commands.add(renderCommand);
        Runnable meshPrimitiveRenderCommand = new Runnable(){

            @Override
            public void run() {
                for (Runnable command : commands) {
                    command.run();
                }
            }

            public String toString() {
                return super.toString();
            }
        };
        boolean bl = isOpaque = !enabledStates.contains(3042);
        if (isOpaque) {
            this.opaqueRenderCommands.add(meshPrimitiveRenderCommand);
        } else {
            this.transparentRenderCommands.add(meshPrimitiveRenderCommand);
        }
        logger.fine("Processing meshPrimitive DONE");
    }

    private Runnable createRenderCommand(MeshPrimitiveModel meshPrimitiveModel, int glVertexArray) {
        int mode = meshPrimitiveModel.getMode();
        AccessorModel indices = meshPrimitiveModel.getIndices();
        if (indices != null) {
            BufferViewModel indicesBufferViewModel = indices.getBufferViewModel();
            Integer glIndicesBufferView = this.gltfRenderData.obtainGlBufferView(indicesBufferViewModel);
            if (glIndicesBufferView == null) {
                logger.warning("No GL bufferView found for indices bufferView " + indicesBufferViewModel);
                return DefaultRenderedGltfModel.emptyRunnable();
            }
            int count = indices.getCount();
            int type = indices.getComponentType();
            int offset = indices.getByteOffset();
            return () -> this.glContext.renderIndexed(glVertexArray, mode, glIndicesBufferView, count, type, offset);
        }
        Map attributes = meshPrimitiveModel.getAttributes();
        if (attributes.isEmpty()) {
            logger.warning("No indices and no attributes found in meshPrimitive");
            return DefaultRenderedGltfModel.emptyRunnable();
        }
        AccessorModel accessorModel = (AccessorModel)attributes.values().iterator().next();
        int count = accessorModel.getCount();
        return () -> this.glContext.renderNonIndexed(glVertexArray, mode, count);
    }

    private List<Runnable> createUniformSettingCommands(MaterialModel materialModel, NodeModel nodeModel, Integer glProgram) {
        ArrayList<Runnable> uniformSettingCommands = new ArrayList<Runnable>();
        TechniqueModel techniqueModel = materialModel.getTechniqueModel();
        Map uniforms = techniqueModel.getUniforms();
        int textureCounter = 0;
        for (String uniformName : uniforms.keySet()) {
            Runnable uniformSettingCommand;
            TechniqueParametersModel techniqueParametersModel = techniqueModel.getUniformParameters(uniformName);
            Supplier<?> uniformValueSupplier = this.uniformGetterFactory.createUniformValueSupplier(uniformName, materialModel, nodeModel);
            int location = this.glContext.getUniformLocation(glProgram, uniformName);
            if (location == -1) {
                logger.warning("No uniform location for uniform " + uniformName);
                continue;
            }
            Integer type = techniqueParametersModel.getType();
            if (type == 35678) {
                int textureIndex = textureCounter++;
                uniformSettingCommand = () -> {
                    Object[] value = (Object[])uniformValueSupplier.get();
                    Object textureIdOrIndex = value[0];
                    if (textureIdOrIndex == null) {
                        return;
                    }
                    TextureModel textureModel = this.textureModelLookup.apply(textureIdOrIndex);
                    if (textureIdOrIndex == null) {
                        logger.warning("No texture ID or index found for uniform " + uniformName);
                    } else {
                        Integer glTexture = this.gltfRenderData.obtainGlTexture(textureModel);
                        if (glTexture == null) {
                            logger.warning("Could not obtain GL texture for texture " + textureIdOrIndex);
                        } else {
                            this.glContext.setUniformSampler(location, textureIndex, glTexture);
                        }
                    }
                };
                uniformSettingCommands.add(RenderCommandUtils.debugUniformSettingCommand(uniformSettingCommand, uniformName, uniformValueSupplier));
                continue;
            }
            int count = techniqueParametersModel.getCount();
            uniformSettingCommand = this.uniformSetterFactory.createUniformSettingCommand(location, type, count, uniformValueSupplier);
            uniformSettingCommands.add(RenderCommandUtils.debugUniformSettingCommand(uniformSettingCommand, uniformName, uniformValueSupplier));
        }
        return uniformSettingCommands;
    }

    private static List<Runnable> createTechniqueStatesFunctionsSettingCommands(GlContext glContext, TechniqueStatesFunctionsModel techniqueStatesFunctionsModel) {
        ArrayList<Runnable> commands = new ArrayList<Runnable>();
        float[] blendColor = techniqueStatesFunctionsModel.getBlendColor();
        commands.add(() -> glContext.setBlendColor(blendColor[0], blendColor[1], blendColor[2], blendColor[3]));
        int[] blendEquationSeparate = techniqueStatesFunctionsModel.getBlendEquationSeparate();
        commands.add(() -> glContext.setBlendEquationSeparate(blendEquationSeparate[0], blendEquationSeparate[1]));
        int[] blendFuncSeparate = techniqueStatesFunctionsModel.getBlendFuncSeparate();
        commands.add(() -> glContext.setBlendFuncSeparate(blendFuncSeparate[0], blendFuncSeparate[1], blendFuncSeparate[2], blendFuncSeparate[3]));
        boolean[] colorMask = techniqueStatesFunctionsModel.getColorMask();
        commands.add(() -> glContext.setColorMask(colorMask[0], colorMask[1], colorMask[2], colorMask[3]));
        int[] cullFace = techniqueStatesFunctionsModel.getCullFace();
        commands.add(() -> glContext.setCullFace(cullFace[0]));
        int[] depthFunc = techniqueStatesFunctionsModel.getDepthFunc();
        commands.add(() -> glContext.setDepthFunc(depthFunc[0]));
        boolean[] depthMask = techniqueStatesFunctionsModel.getDepthMask();
        commands.add(() -> glContext.setDepthMask(depthMask[0]));
        float[] depthRange = techniqueStatesFunctionsModel.getDepthRange();
        commands.add(() -> glContext.setDepthRange(depthRange[0], depthRange[1]));
        int[] frontFace = techniqueStatesFunctionsModel.getFrontFace();
        commands.add(() -> glContext.setFrontFace(frontFace[0]));
        float[] lineWidth = techniqueStatesFunctionsModel.getLineWidth();
        commands.add(() -> glContext.setLineWidth(lineWidth[0]));
        float[] polygonOffset = techniqueStatesFunctionsModel.getPolygonOffset();
        commands.add(() -> glContext.setPolygonOffset(polygonOffset[0], polygonOffset[1]));
        return commands;
    }

    private List<Runnable> createAttributes(int glVertexArray, NodeModel nodeModel, MeshModel meshModel, MeshPrimitiveModel meshPrimitiveModel) {
        ArrayList<Runnable> attributeUpdateCommands = new ArrayList<Runnable>();
        MaterialModel materialModel = meshPrimitiveModel.getMaterialModel();
        TechniqueModel techniqueModel = materialModel.getTechniqueModel();
        ProgramModel programModel = techniqueModel.getProgramModel();
        Integer glProgram = this.gltfRenderData.obtainGlProgram(programModel);
        if (glProgram == null) {
            logger.warning("No GL program found for program " + programModel + " in technique " + techniqueModel);
            return attributeUpdateCommands;
        }
        Map meshPrimitiveAttributes = meshPrimitiveModel.getAttributes();
        Map attributes = techniqueModel.getAttributes();
        for (String attributeName : attributes.keySet()) {
            int attributeLocation;
            TechniqueParametersModel attributeTechniqueParametersModel = techniqueModel.getAttributeParameters(attributeName);
            String semantic = attributeTechniqueParametersModel.getSemantic();
            AccessorModel accessorModel = null;
            Morphing.MorphableAttribute morphableAttribute = null;
            if (Morphing.isMorphableAttribute(meshPrimitiveModel, semantic)) {
                morphableAttribute = Morphing.createMorphableAttribute(meshPrimitiveModel, semantic);
                accessorModel = morphableAttribute.getMorphedAccessorModel();
            } else {
                accessorModel = (AccessorModel)meshPrimitiveAttributes.get(semantic);
            }
            if (accessorModel == null) {
                logger.fine("No accessor model found for semantic " + semantic);
                continue;
            }
            BufferViewModel bufferViewModel = accessorModel.getBufferViewModel();
            Integer glBufferView = this.gltfRenderData.obtainGlBufferView(bufferViewModel);
            if (glBufferView == null) {
                logger.warning("No GL bufferView found for bufferView " + bufferViewModel);
                continue;
            }
            if (morphableAttribute != null) {
                Runnable attributeUpdateCommand = this.createAttributeUpdateCommand(glVertexArray, glBufferView, nodeModel, meshModel, morphableAttribute);
                attributeUpdateCommands.add(attributeUpdateCommand);
            }
            if ((attributeLocation = this.glContext.getAttributeLocation(glProgram, attributeName)) == -1) {
                logger.warning("No attribute location for attribute " + attributeName + " in program " + programModel + ". The attribute name in the shader must match the key of the 'attributes' dictionary.");
            }
            int target = (Integer)Optionals.of((Object)bufferViewModel.getTarget(), (Object)34962);
            int size = accessorModel.getElementType().getNumComponents();
            int type = accessorModel.getComponentType();
            int stride = accessorModel.getByteStride();
            int offset = accessorModel.getByteOffset();
            this.glContext.createVertexAttribute(glVertexArray, target, glBufferView, attributeLocation, size, type, stride, offset);
        }
        return attributeUpdateCommands;
    }

    private Runnable createAttributeUpdateCommand(final int glVertexArray, final int glBufferView, final NodeModel nodeModel, final MeshModel meshModel, final Morphing.MorphableAttribute morphableAttribute) {
        AccessorModel morphedAccessorModel = morphableAttribute.getMorphedAccessorModel();
        BufferViewModel morphedBufferViewModel = morphedAccessorModel.getBufferViewModel();
        morphedBufferViewModel.getByteLength();
        final ByteBuffer morphedBufferViewData = morphedBufferViewModel.getBufferViewData();
        final int bufferSize = morphedBufferViewData.capacity();
        final float[] weights = new float[morphableAttribute.getNumTargets()];
        Runnable attributeUpdateCommand = new Runnable(){

            @Override
            public void run() {
                if (nodeModel.getWeights() != null) {
                    System.arraycopy(nodeModel.getWeights(), 0, weights, 0, weights.length);
                } else if (meshModel.getWeights() != null) {
                    System.arraycopy(meshModel.getWeights(), 0, weights, 0, weights.length);
                }
                morphableAttribute.updateMorphedAccessorData(weights);
                DefaultRenderedGltfModel.this.glContext.updateVertexAttribute(glVertexArray, 34962, glBufferView, 0, bufferSize, morphedBufferViewData);
            }
        };
        return attributeUpdateCommand;
    }

    private static Runnable emptyRunnable() {
        return () -> {};
    }
}

