/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

class MatrixOps {
    private static final Logger logger = Logger.getLogger(MatrixOps.class.getName());
    private final Supplier<float[]> inputSupplier;
    private final List<Function<float[], float[]>> functions;

    static MatrixOps create4x4(Supplier<float[]> inputSupplier) {
        return new MatrixOps(inputSupplier);
    }

    static MatrixOps create4x4() {
        return MatrixOps.create4x4(MatrixOps.createIdentitySupplier4x4());
    }

    private static Supplier<float[]> createIdentitySupplier4x4() {
        float[] matrix = new float[16];
        return () -> {
            MathUtils.setIdentity4x4((float[])matrix);
            return matrix;
        };
    }

    private MatrixOps(Supplier<float[]> inputSupplier) {
        this.inputSupplier = inputSupplier;
        this.functions = new ArrayList<Function<float[], float[]>>();
    }

    MatrixOps multiply4x4(Supplier<float[]> operandSupplier) {
        float[] result = new float[16];
        this.functions.add(MatrixOps.named("multiply4x4", input -> {
            MathUtils.mul4x4((float[])input, (float[])((float[])operandSupplier.get()), (float[])result);
            return result;
        }));
        return this;
    }

    MatrixOps invert4x4() {
        float[] result = new float[16];
        this.functions.add(MatrixOps.named("invert4x4", input -> {
            MathUtils.invert4x4((float[])input, (float[])result);
            return result;
        }));
        return this;
    }

    MatrixOps invert3x3() {
        float[] result = new float[9];
        this.functions.add(MatrixOps.named("invert3x4", input -> {
            MathUtils.invert3x3((float[])input, (float[])result);
            return result;
        }));
        return this;
    }

    MatrixOps transpose4x4() {
        float[] result = new float[16];
        this.functions.add(MatrixOps.named("transpose4x4", input -> {
            MathUtils.transpose4x4((float[])input, (float[])result);
            return result;
        }));
        return this;
    }

    MatrixOps getRotationScale() {
        float[] result = new float[9];
        this.functions.add(MatrixOps.named("getRotationScale", input -> {
            MathUtils.getRotationScale((float[])input, (float[])result);
            return result;
        }));
        return this;
    }

    MatrixOps log(String name, Level level) {
        this.functions.add(MatrixOps.named("log " + name, input -> {
            if (logger.isLoggable(level)) {
                logger.log(level, name + ":\n" + MathUtils.createMatrixString((float[])input));
            }
            return input;
        }));
        return this;
    }

    private static <S, T> Function<S, T> named(final String name, final Function<S, T> function) {
        return new Function<S, T>(){

            @Override
            public T apply(S s) {
                return function.apply(s);
            }

            public String toString() {
                return name;
            }
        };
    }

    Supplier<float[]> build() {
        return () -> {
            float[] current = this.inputSupplier.get();
            for (Function<float[], float[]> function : this.functions) {
                current = function.apply(current);
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("current is " + Arrays.toString(current) + " after " + function);
            }
            return current;
        };
    }
}

