/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.CameraModel;
import de.javagl.jgltf.model.GltfAnimations;
import de.javagl.jgltf.model.GltfModel;
import de.javagl.jgltf.model.TextureModel;
import de.javagl.jgltf.model.animation.Animation;
import de.javagl.jgltf.model.animation.AnimationManager;
import de.javagl.jgltf.model.animation.AnimationRunner;
import de.javagl.jgltf.model.v1.GltfModelV1;
import de.javagl.jgltf.model.v2.GltfModelV2;
import de.javagl.jgltf.viewer.DefaultRenderedGltfModel;
import de.javagl.jgltf.viewer.ExternalCamera;
import de.javagl.jgltf.viewer.GlContext;
import de.javagl.jgltf.viewer.GltfViewer;
import de.javagl.jgltf.viewer.RenderedGltfModel;
import de.javagl.jgltf.viewer.ViewConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;

public abstract class AbstractGltfViewer<C>
implements GltfViewer<C> {
    private static final Logger logger = Logger.getLogger(AbstractGltfViewer.class.getName());
    private final Supplier<float[]> viewportSupplier = new Supplier<float[]>(){
        private final float[] viewport = new float[4];

        @Override
        public float[] get() {
            this.viewport[0] = 0.0f;
            this.viewport[1] = 0.0f;
            this.viewport[2] = AbstractGltfViewer.this.getWidth();
            this.viewport[3] = AbstractGltfViewer.this.getHeight();
            return this.viewport;
        }
    };
    private final DoubleSupplier aspectRatioSupplier = () -> (double)this.getWidth() / (double)this.getHeight();
    private ExternalCamera externalCamera;
    private final List<Runnable> beforeRenderTasks = Collections.synchronizedList(new ArrayList());
    private final Map<GltfModel, RenderedGltfModel> renderedGltfModels = new LinkedHashMap<GltfModel, RenderedGltfModel>();
    private final List<GltfModel> gltfModels = new ArrayList<GltfModel>();
    private final AnimationManager animationManager = GltfAnimations.createAnimationManager((AnimationManager.AnimationPolicy)AnimationManager.AnimationPolicy.LOOP);
    private final AnimationRunner animationRunner;
    private final Map<GltfModel, List<Animation>> modelAnimations;

    protected AbstractGltfViewer() {
        this.animationManager.addAnimationManagerListener(a -> this.triggerRendering());
        this.animationRunner = new AnimationRunner(this.animationManager);
        this.modelAnimations = new LinkedHashMap<GltfModel, List<Animation>>();
        this.setAnimationsRunning(true);
    }

    @Override
    public final void setExternalCamera(ExternalCamera externalCamera) {
        this.externalCamera = externalCamera;
    }

    @Override
    public final void setAnimationsRunning(boolean running) {
        if (running) {
            this.animationRunner.start();
        } else {
            this.animationRunner.stop();
        }
    }

    @Override
    public abstract C getRenderComponent();

    protected abstract GlContext getGlContext();

    @Override
    public final void addGltfModel(GltfModel gltfModel) {
        List cameraModels;
        Objects.requireNonNull(gltfModel, "The gltfModel may not be null");
        this.gltfModels.add(gltfModel);
        this.addBeforeRenderTask(() -> this.createRenderedGltf(gltfModel));
        this.triggerRendering();
        if (this.externalCamera == null && !(cameraModels = gltfModel.getCameraModels()).isEmpty()) {
            CameraModel cameraModel = (CameraModel)cameraModels.get(0);
            this.setCurrentCameraModel(gltfModel, cameraModel);
        }
    }

    private void createRenderedGltf(GltfModel gltfModel) {
        Supplier<float[]> viewMatrixSupplier = null;
        Supplier<float[]> projectionMatrixSupplier = null;
        if (this.externalCamera != null) {
            viewMatrixSupplier = () -> this.externalCamera.getViewMatrix();
            projectionMatrixSupplier = () -> this.externalCamera.getProjectionMatrix();
        }
        logger.info("Creating rendered glTF");
        ViewConfiguration viewConfiguration = new ViewConfiguration(this.viewportSupplier, this.aspectRatioSupplier, viewMatrixSupplier, projectionMatrixSupplier);
        GlContext glContext = this.getGlContext();
        DefaultRenderedGltfModel renderedGltfModel = null;
        if (gltfModel instanceof GltfModelV1) {
            GltfModelV1 gltfModelV1 = (GltfModelV1)gltfModel;
            Function<Object, TextureModel> textureModelLookup = object -> {
                String textureId = String.valueOf(object);
                return gltfModelV1.getTextureModelById(textureId);
            };
            renderedGltfModel = new DefaultRenderedGltfModel(glContext, (GltfModel)gltfModelV1, textureModelLookup, viewConfiguration);
        } else if (gltfModel instanceof GltfModelV2) {
            GltfModelV2 gltfModelV2 = (GltfModelV2)gltfModel;
            Function<Object, TextureModel> textureModelLookup = object -> {
                Number number = (Number)object;
                int index = number.intValue();
                return (TextureModel)gltfModelV2.getTextureModels().get(index);
            };
            renderedGltfModel = new DefaultRenderedGltfModel(glContext, (GltfModel)gltfModelV2, textureModelLookup, viewConfiguration);
        } else {
            logger.severe("GltfModel version is not supported: " + gltfModel);
            return;
        }
        this.renderedGltfModels.put(gltfModel, renderedGltfModel);
        List currentModelAnimations = GltfAnimations.createModelAnimations((Iterable)gltfModel.getAnimationModels());
        this.modelAnimations.put(gltfModel, currentModelAnimations);
        this.animationManager.addAnimations((Iterable)currentModelAnimations);
    }

    @Override
    public void removeGltfModel(GltfModel gltfModel) {
        Objects.requireNonNull(gltfModel, "The gltfModel may not be null");
        this.gltfModels.remove(gltfModel);
        this.addBeforeRenderTask(() -> this.deleteRenderedGltfModel(gltfModel));
        List<Animation> currentModelAnimations = this.modelAnimations.get(gltfModel);
        if (currentModelAnimations != null) {
            this.animationManager.removeAnimations(currentModelAnimations);
        }
        this.modelAnimations.remove(gltfModel);
        this.triggerRendering();
    }

    private void deleteRenderedGltfModel(GltfModel gltfModel) {
        RenderedGltfModel renderedGltfModel = this.renderedGltfModels.get(gltfModel);
        if (renderedGltfModel == null) {
            logger.warning("No renderedGltfModel found for gltfModel " + gltfModel);
            return;
        }
        logger.info("Deleting rendered glTF");
        renderedGltfModel.delete();
        this.renderedGltfModels.remove(gltfModel);
    }

    @Override
    public List<CameraModel> getCameraModels() {
        ArrayList cameraModels = new ArrayList();
        for (GltfModel gltfModel : this.gltfModels) {
            cameraModels.addAll(gltfModel.getCameraModels());
        }
        return Collections.unmodifiableList(cameraModels);
    }

    @Override
    public void setCurrentCameraModel(GltfModel gltfModel, CameraModel cameraModel) {
        if (gltfModel != null && !this.gltfModels.contains(gltfModel)) {
            throw new IllegalArgumentException("The given gltfModel is not contained in this viewer");
        }
        this.addBeforeRenderTask(() -> this.setCurrentCameraModelInternal(gltfModel, cameraModel));
        this.triggerRendering();
    }

    private void setCurrentCameraModelInternal(GltfModel gltfModel, CameraModel cameraModel) {
        if (gltfModel == null) {
            for (RenderedGltfModel renderedGltf : this.renderedGltfModels.values()) {
                renderedGltf.setCurrentCameraModel(cameraModel);
            }
        } else {
            RenderedGltfModel renderedGltf = this.renderedGltfModels.get(gltfModel);
            if (renderedGltf == null) {
                logger.warning("Rendered glTF model has been removed");
                return;
            }
            renderedGltf.setCurrentCameraModel(cameraModel);
        }
    }

    private void addBeforeRenderTask(Runnable beforeRenderTask) {
        this.beforeRenderTasks.add(beforeRenderTask);
    }

    protected final void doRender() {
        this.prepareRender();
        this.beforeRender();
        this.render();
    }

    protected abstract void prepareRender();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeRender() {
        List<Runnable> list = this.beforeRenderTasks;
        synchronized (list) {
            while (this.beforeRenderTasks.size() > 0) {
                Runnable beforeRenderTask = this.beforeRenderTasks.get(0);
                beforeRenderTask.run();
                this.beforeRenderTasks.remove(0);
            }
        }
    }

    protected abstract void render();

    protected final void renderGltfModels() {
        for (RenderedGltfModel renderedGltfModel : this.renderedGltfModels.values()) {
            renderedGltfModel.render();
        }
    }
}

