/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.MaterialModel;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.model.SkinModel;
import de.javagl.jgltf.model.gl.Semantic;
import de.javagl.jgltf.model.gl.TechniqueModel;
import de.javagl.jgltf.model.gl.TechniqueParametersModel;
import de.javagl.jgltf.viewer.MatrixOps;
import de.javagl.jgltf.viewer.UniformGetters;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

class UniformGetterFactory {
    private static final Logger logger = Logger.getLogger(UniformGetterFactory.class.getName());
    private final Supplier<float[]> viewMatrixSupplier;
    private final Supplier<float[]> projectionMatrixSupplier;
    private final Supplier<float[]> viewportSupplier;
    private final Set<String> reportedNullUniformNames;

    public UniformGetterFactory(Supplier<float[]> viewportSupplier, Supplier<float[]> viewMatrixSupplier, Supplier<float[]> projectionMatrixSupplier) {
        this.viewportSupplier = Objects.requireNonNull(viewportSupplier, "The viewportSupplier may not be null");
        this.viewMatrixSupplier = Objects.requireNonNull(viewMatrixSupplier, "The viewMatrixSupplier may not be null");
        this.projectionMatrixSupplier = Objects.requireNonNull(projectionMatrixSupplier, "The projectionMatrixSupplier may not be null");
        this.reportedNullUniformNames = new LinkedHashSet<String>();
    }

    public Supplier<?> createUniformValueSupplier(String uniformName, MaterialModel materialModel, NodeModel nodeModel) {
        TechniqueModel techniqueModel = materialModel.getTechniqueModel();
        Map uniforms = techniqueModel.getUniforms();
        String parameterName = (String)uniforms.get(uniformName);
        Map parameters = techniqueModel.getParameters();
        TechniqueParametersModel techniqueParametersModel = (TechniqueParametersModel)parameters.get(parameterName);
        String semantic = techniqueParametersModel.getSemantic();
        if (semantic == null) {
            Supplier<?> supplier = UniformGetters.createGenericSupplier(uniformName, materialModel);
            return this.createNullLoggingSupplier(uniformName, supplier);
        }
        return this.createSemanticBasedSupplier(uniformName, techniqueModel, nodeModel);
    }

    private Supplier<?> createNullLoggingSupplier(String uniformName, Supplier<?> supplier) {
        return () -> {
            Object result = supplier.get();
            if (result == null && !this.reportedNullUniformNames.contains(uniformName)) {
                logger.warning("Uniform value is null for " + uniformName);
                this.reportedNullUniformNames.add(uniformName);
            }
            return result;
        };
    }

    private Supplier<?> createSemanticBasedSupplier(String uniformName, TechniqueModel techniqueModel, NodeModel currentNodeModel) {
        Objects.requireNonNull(uniformName, "The uniformName may not be null");
        Objects.requireNonNull(techniqueModel, "The techniqueModel may not be null");
        Objects.requireNonNull(currentNodeModel, "The currentNodeModel may not be null");
        TechniqueParametersModel techniqueParameters = techniqueModel.getUniformParameters(uniformName);
        String semanticString = techniqueParameters.getSemantic();
        if (!Semantic.contains((String)semanticString)) {
            throw new IllegalArgumentException("Uniform " + uniformName + " has invalid semantic " + semanticString + " in technique " + techniqueModel);
        }
        Semantic semantic = Semantic.valueOf((String)semanticString);
        NodeModel nodeModel = currentNodeModel;
        NodeModel parameterNodeModel = techniqueParameters.getNodeModel();
        if (parameterNodeModel != null) {
            nodeModel = parameterNodeModel;
        }
        switch (semantic) {
            case LOCAL: {
                return nodeModel.createLocalTransformSupplier();
            }
            case MODEL: {
                return nodeModel.createGlobalTransformSupplier();
            }
            case VIEW: {
                return this.viewMatrixSupplier;
            }
            case PROJECTION: {
                return this.projectionMatrixSupplier;
            }
            case MODELVIEW: {
                Supplier modelMatrixSupplier = nodeModel.createGlobalTransformSupplier();
                return MatrixOps.create4x4(this.viewMatrixSupplier).multiply4x4(modelMatrixSupplier).log(semanticString, Level.FINE).build();
            }
            case MODELVIEWPROJECTION: {
                Supplier modelMatrixSupplier = nodeModel.createGlobalTransformSupplier();
                return MatrixOps.create4x4(this.projectionMatrixSupplier).multiply4x4(this.viewMatrixSupplier).multiply4x4(modelMatrixSupplier).log(semanticString, Level.FINE).build();
            }
            case MODELINVERSE: {
                Supplier modelMatrixSupplier = nodeModel.createGlobalTransformSupplier();
                return MatrixOps.create4x4(modelMatrixSupplier).invert4x4().log(semanticString, Level.FINE).build();
            }
            case VIEWINVERSE: {
                return MatrixOps.create4x4(this.viewMatrixSupplier).invert4x4().log(semanticString, Level.FINE).build();
            }
            case MODELVIEWINVERSE: {
                Supplier modelMatrixSupplier = nodeModel.createGlobalTransformSupplier();
                return MatrixOps.create4x4(this.viewMatrixSupplier).multiply4x4(modelMatrixSupplier).invert4x4().log(semanticString, Level.FINE).build();
            }
            case PROJECTIONINVERSE: {
                return MatrixOps.create4x4(this.projectionMatrixSupplier).invert4x4().log(semanticString, Level.FINE).build();
            }
            case MODELVIEWPROJECTIONINVERSE: {
                Supplier modelMatrixSupplier = nodeModel.createGlobalTransformSupplier();
                return MatrixOps.create4x4(this.projectionMatrixSupplier).multiply4x4(this.viewMatrixSupplier).multiply4x4(modelMatrixSupplier).invert4x4().log(semanticString, Level.FINE).build();
            }
            case MODELINVERSETRANSPOSE: {
                Supplier modelMatrixSupplier = nodeModel.createGlobalTransformSupplier();
                return MatrixOps.create4x4(modelMatrixSupplier).invert4x4().transpose4x4().getRotationScale().log(semanticString, Level.FINE).build();
            }
            case MODELVIEWINVERSETRANSPOSE: {
                Supplier modelMatrixSupplier = nodeModel.createGlobalTransformSupplier();
                return MatrixOps.create4x4(this.viewMatrixSupplier).multiply4x4(modelMatrixSupplier).invert4x4().transpose4x4().getRotationScale().log(semanticString, Level.FINE).build();
            }
            case VIEWPORT: {
                return this.viewportSupplier;
            }
            case JOINTMATRIX: {
                return UniformGetterFactory.createJointMatrixSupplier(currentNodeModel);
            }
        }
        logger.severe("Unsupported semantic: " + semantic);
        return null;
    }

    private static Supplier<float[]> createJointMatrixSupplier(NodeModel nodeModel) {
        Supplier inverseBindMatrixSupplier;
        SkinModel skinModel = nodeModel.getSkinModel();
        float[] bindShapeMatrix = skinModel.getBindShapeMatrix(null);
        Supplier<float[]> bindShapeMatrixSupplier = MatrixOps.create4x4(() -> bindShapeMatrix).log("bindShapeMatrix", Level.FINE).build();
        List joints = skinModel.getJoints();
        int numJoints = joints.size();
        ArrayList<Supplier<float[]>> inverseBindMatrixSuppliers = new ArrayList<Supplier<float[]>>();
        for (int i = 0; i < numJoints; ++i) {
            int currentJointIndex = i;
            float[] inverseBindMatrix = new float[16];
            inverseBindMatrixSupplier = () -> skinModel.getInverseBindMatrix(currentJointIndex, inverseBindMatrix);
            Supplier<float[]> loggingInverseBindMatrixSupplier = MatrixOps.create4x4(inverseBindMatrixSupplier).log("inverseBindMatrix " + i, Level.FINE).build();
            inverseBindMatrixSuppliers.add(loggingInverseBindMatrixSupplier);
        }
        ArrayList<Supplier<float[]>> jointMatrixSuppliers = new ArrayList<Supplier<float[]>>();
        for (int j = 0; j < numJoints; ++j) {
            NodeModel jointNodeModel = (NodeModel)joints.get(j);
            inverseBindMatrixSupplier = (Supplier)inverseBindMatrixSuppliers.get(j);
            Supplier<float[]> jointMatrixSupplier = MatrixOps.create4x4(nodeModel.createGlobalTransformSupplier()).invert4x4().multiply4x4(jointNodeModel.createGlobalTransformSupplier()).multiply4x4(inverseBindMatrixSupplier).multiply4x4(bindShapeMatrixSupplier).log("jointMatrix " + j, Level.FINE).build();
            jointMatrixSuppliers.add(jointMatrixSupplier);
        }
        float[] jointMatrices = new float[jointMatrixSuppliers.size() * 16];
        return () -> {
            for (int i = 0; i < jointMatrixSuppliers.size(); ++i) {
                Supplier jointMatrixSupplier = (Supplier)jointMatrixSuppliers.get(i);
                float[] jointMatrix = (float[])jointMatrixSupplier.get();
                System.arraycopy(jointMatrix, 0, jointMatrices, i * 16, 16);
            }
            return jointMatrices;
        };
    }
}

