/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.AccessorByteData;
import de.javagl.jgltf.model.AccessorData;
import de.javagl.jgltf.model.AccessorFloatData;
import de.javagl.jgltf.model.AccessorIntData;
import de.javagl.jgltf.model.AccessorShortData;

class AccessorDataUtils {
    static int[] readInts(AccessorData accessorData) {
        int numElements = accessorData.getNumElements();
        int numComponents = accessorData.getNumComponentsPerElement();
        if (accessorData instanceof AccessorByteData) {
            AccessorByteData accessorByteData = (AccessorByteData)accessorData;
            return AccessorDataUtils.readIntsFromBytes(accessorByteData, numElements, numComponents);
        }
        if (accessorData instanceof AccessorShortData) {
            AccessorShortData accessorShortData = (AccessorShortData)accessorData;
            return AccessorDataUtils.readIntsFromShorts(accessorShortData, numElements, numComponents);
        }
        if (accessorData instanceof AccessorIntData) {
            AccessorIntData accessorIntData = (AccessorIntData)accessorData;
            return AccessorDataUtils.readIntsFromInts(accessorIntData, numElements, numComponents);
        }
        throw new IllegalArgumentException("Not a valid index type: " + accessorData);
    }

    private static int[] readIntsFromBytes(AccessorByteData accessorByteData, int numElements, int numComponents) {
        int n = numElements * numComponents;
        int[] result = new int[n];
        int index = 0;
        for (int e = 0; e < numElements; ++e) {
            for (int c = 0; c < numComponents; ++c) {
                result[index] = accessorByteData.getInt(e, c);
                ++index;
            }
        }
        return result;
    }

    private static int[] readIntsFromShorts(AccessorShortData accessorShortData, int numElements, int numComponents) {
        int n = numElements * numComponents;
        int[] result = new int[n];
        int index = 0;
        for (int e = 0; e < numElements; ++e) {
            for (int c = 0; c < numComponents; ++c) {
                result[index] = accessorShortData.getInt(e, c);
                ++index;
            }
        }
        return result;
    }

    private static int[] readIntsFromInts(AccessorIntData accessorIntData, int numElements, int numComponents) {
        int n = numElements * numComponents;
        int[] result = new int[n];
        int index = 0;
        for (int e = 0; e < numElements; ++e) {
            for (int c = 0; c < numComponents; ++c) {
                result[index] = accessorIntData.get(e, c);
                ++index;
            }
        }
        return result;
    }

    static float[] readFloats(AccessorFloatData accessorData, int numElements, int numComponents) {
        int n = numElements * numComponents;
        float[] result = new float[n];
        int index = 0;
        for (int e = 0; e < numElements; ++e) {
            for (int c = 0; c < numComponents; ++c) {
                result[index] = accessorData.get(e, c);
                ++index;
            }
        }
        return result;
    }

    static void writeFloats(AccessorFloatData accessorData, int numElements, int numComponents, float[] data) {
        int index = 0;
        for (int e = 0; e < numElements; ++e) {
            for (int c = 0; c < numComponents; ++c) {
                accessorData.set(e, c, data[index]);
                ++index;
            }
        }
    }

    static void copyFloats(AccessorFloatData target, AccessorFloatData source) {
        int numElements = Math.min(target.getNumElements(), source.getNumElements());
        int numComponents = Math.min(target.getNumComponentsPerElement(), source.getNumComponentsPerElement());
        for (int e = 0; e < numElements; ++e) {
            for (int c = 0; c < numComponents; ++c) {
                float value = source.get(e, c);
                target.set(e, c, value);
            }
        }
    }

    private AccessorDataUtils() {
    }
}

