/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.AccessorData;
import de.javagl.jgltf.model.AccessorFloatData;
import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.BufferViewModel;
import de.javagl.jgltf.model.ElementType;
import de.javagl.jgltf.model.impl.DefaultAccessorModel;
import de.javagl.jgltf.model.impl.DefaultBufferModel;
import de.javagl.jgltf.model.impl.DefaultBufferViewModel;
import de.javagl.jgltf.model.io.Buffers;
import de.javagl.jgltf.viewer.AccessorDataUtils;
import java.nio.ByteBuffer;

class AccessorModelCreation {
    static AccessorModel instantiate(AccessorModel accessorModel, String bufferUriString) {
        AccessorModel instantiatedAccessorModel = AccessorModelCreation.createAccessorModel(accessorModel.getComponentType(), accessorModel.getCount(), accessorModel.getElementType(), bufferUriString);
        AccessorData accessorData = accessorModel.getAccessorData();
        AccessorFloatData accessorFloatData = (AccessorFloatData)accessorData;
        AccessorData instantiatedAccessorData = instantiatedAccessorModel.getAccessorData();
        AccessorFloatData instantiatedAccessorFloatData = (AccessorFloatData)instantiatedAccessorData;
        AccessorDataUtils.copyFloats(instantiatedAccessorFloatData, accessorFloatData);
        return instantiatedAccessorModel;
    }

    static AccessorModel createAccessorModel(int componentType, int count, ElementType elementType, String bufferUriString) {
        DefaultAccessorModel accessorModel = new DefaultAccessorModel(componentType, count, elementType);
        int elementSize = accessorModel.getElementSizeInBytes();
        accessorModel.setByteOffset(0);
        ByteBuffer bufferData = Buffers.create((int)(count * elementSize));
        accessorModel.setBufferViewModel((BufferViewModel)AccessorModelCreation.createBufferViewModel(bufferUriString, bufferData));
        return accessorModel;
    }

    private static DefaultBufferViewModel createBufferViewModel(String uriString, ByteBuffer bufferData) {
        DefaultBufferModel bufferModel = new DefaultBufferModel();
        bufferModel.setUri(uriString);
        bufferModel.setBufferData(bufferData);
        DefaultBufferViewModel bufferViewModel = new DefaultBufferViewModel(null);
        bufferViewModel.setByteOffset(0);
        bufferViewModel.setByteLength(bufferData.capacity());
        bufferViewModel.setBufferModel((BufferModel)bufferModel);
        return bufferViewModel;
    }

    private AccessorModelCreation() {
    }
}

