/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.GltfModel;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.viewer.MatrixOps;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

class CesiumRtcUtils {
    private static final Logger logger = Logger.getLogger(CesiumRtcUtils.class.getName());
    private static final String CESIUM_RTC_MODELVIEW_SEMANTIC_STRING = "CESIUM_RTC_MODELVIEW";

    static boolean isCesiumRtcModelViewSemantic(String semanticString) {
        return CESIUM_RTC_MODELVIEW_SEMANTIC_STRING.equals(semanticString);
    }

    static Supplier<float[]> createCesiumRtcModelViewMatrixSupplier(NodeModel nodeModel, Supplier<float[]> viewMatrixSupplier, float[] rtcCenter) {
        Supplier modelMatrixSupplier = nodeModel.createGlobalTransformSupplier();
        return MatrixOps.create4x4().multiply4x4(viewMatrixSupplier).multiply4x4(modelMatrixSupplier).translate(rtcCenter[0], rtcCenter[1], rtcCenter[2]).log(CESIUM_RTC_MODELVIEW_SEMANTIC_STRING, Level.FINE).build();
    }

    static float[] extractRtcCenterFromModel(GltfModel gltfModel) {
        Map extensions = gltfModel.getExtensions();
        if (extensions == null) {
            return null;
        }
        Object rtcExtension = extensions.get("CESIUM_RTC");
        return CesiumRtcUtils.extractRtcCenterFromExtensionObbject(rtcExtension);
    }

    private static float[] extractRtcCenterFromExtensionObbject(Object extensionObject) {
        if (extensionObject == null) {
            return null;
        }
        if (!(extensionObject instanceof Map)) {
            logger.warning("CESIUM_RTC extension object has invalid type. Expected Map<?, ?>. Found " + extensionObject.getClass());
            return null;
        }
        Map extension = (Map)extensionObject;
        Object center = extension.get("center");
        if (!(center instanceof List)) {
            logger.warning("CESIUM_RTC extension center value has invalid type. Expected List<?>. Found " + center.getClass());
            return null;
        }
        List list = (List)center;
        if (list.size() != 3) {
            logger.warning("CESIUM_RTC extension center value must have size 3, but has " + list.size());
            return null;
        }
        float[] result = new float[3];
        for (int i = 0; i < list.size(); ++i) {
            Object value = list.get(i);
            if (!(value instanceof Number)) {
                logger.warning("CESIUM_RTC extension center value at index " + i + " is not a number, but " + value.getClass());
                return null;
            }
            Number number = (Number)value;
            result[i] = number.floatValue();
        }
        return result;
    }

    private CesiumRtcUtils() {
    }
}

