/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.BufferViewModel;
import de.javagl.jgltf.model.GltfModel;
import de.javagl.jgltf.model.MaterialModel;
import de.javagl.jgltf.model.MeshModel;
import de.javagl.jgltf.model.MeshPrimitiveModel;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.SceneModel;
import de.javagl.jgltf.model.SkinModel;
import de.javagl.jgltf.model.TextureModel;
import de.javagl.jgltf.model.gl.ProgramModel;
import de.javagl.jgltf.model.gl.TechniqueModel;
import de.javagl.jgltf.model.gl.TechniqueParametersModel;
import de.javagl.jgltf.model.gl.TechniqueStatesFunctionsModel;
import de.javagl.jgltf.model.gl.TechniqueStatesModel;
import de.javagl.jgltf.model.gl.impl.TechniqueStatesModels;
import de.javagl.jgltf.model.v1.MaterialModelV1;
import de.javagl.jgltf.model.v1.gl.DefaultModels;
import de.javagl.jgltf.model.v2.MaterialModelV2;
import de.javagl.jgltf.viewer.CesiumRtcUtils;
import de.javagl.jgltf.viewer.DefaultRenderedMaterial;
import de.javagl.jgltf.viewer.GlContext;
import de.javagl.jgltf.viewer.GltfRenderData;
import de.javagl.jgltf.viewer.Morphing;
import de.javagl.jgltf.viewer.NormalComputation;
import de.javagl.jgltf.viewer.RenderCommandUtils;
import de.javagl.jgltf.viewer.RenderedGltfModel;
import de.javagl.jgltf.viewer.RenderedMaterial;
import de.javagl.jgltf.viewer.RenderedMaterialHandler;
import de.javagl.jgltf.viewer.TechniqueStatesFunctions;
import de.javagl.jgltf.viewer.UniformGetterFactory;
import de.javagl.jgltf.viewer.UniformSetterFactory;
import de.javagl.jgltf.viewer.ViewConfiguration;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;

class DefaultRenderedGltfModel
implements RenderedGltfModel {
    private static final Logger logger = Logger.getLogger(DefaultRenderedGltfModel.class.getName());
    private final GlContext glContext;
    private final GltfRenderData gltfRenderData;
    private final UniformGetterFactory uniformGetterFactory;
    private final UniformSetterFactory uniformSetterFactory;
    private final RenderedMaterialHandler materialModelHandler;
    private final List<Runnable> opaqueRenderCommands;
    private final List<Runnable> transparentRenderCommands;

    public DefaultRenderedGltfModel(GlContext glContext, GltfModel gltfModel, ViewConfiguration viewConfiguration) {
        Objects.requireNonNull(gltfModel, "The gltfModel may not be null");
        this.glContext = glContext;
        Objects.requireNonNull(viewConfiguration, "The viewConfiguration may not be null");
        float[] rtcCenter = CesiumRtcUtils.extractRtcCenterFromModel(gltfModel);
        if (rtcCenter != null) {
            logger.info("CESIUM_RTC center is " + Arrays.toString(rtcCenter));
            logger.info("Resetting to 0, 0, 0");
            rtcCenter[0] = 0.0f;
            rtcCenter[1] = 0.0f;
            rtcCenter[2] = 0.0f;
        }
        this.gltfRenderData = new GltfRenderData(glContext);
        this.uniformGetterFactory = new UniformGetterFactory(viewConfiguration::getViewport, viewConfiguration::getViewMatrix, viewConfiguration::getProjectionMatrix, rtcCenter);
        this.uniformSetterFactory = new UniformSetterFactory(glContext);
        Map textureIndexMap = DefaultRenderedGltfModel.computeIndexMap(gltfModel.getTextureModels());
        this.materialModelHandler = new RenderedMaterialHandler(textureIndexMap::get);
        this.opaqueRenderCommands = new ArrayList<Runnable>();
        this.transparentRenderCommands = new ArrayList<Runnable>();
        logger.fine("Processing scenes...");
        Optionals.of((List)gltfModel.getSceneModels()).forEach(this::processSceneModel);
        logger.fine("Processing scenes DONE...");
    }

    @Override
    public void delete() {
        this.gltfRenderData.delete();
        this.opaqueRenderCommands.clear();
        this.transparentRenderCommands.clear();
        this.opaqueRenderCommands.add(() -> logger.warning("Rendered object has been deleted"));
    }

    @Override
    public void render() {
        for (Runnable renderCommand : this.opaqueRenderCommands) {
            renderCommand.run();
        }
        for (Runnable renderCommand : this.transparentRenderCommands) {
            renderCommand.run();
        }
    }

    private void processSceneModel(SceneModel sceneModel) {
        logger.fine("Processing scene " + sceneModel);
        List nodeModels = sceneModel.getNodeModels();
        for (NodeModel nodeModel : nodeModels) {
            this.processNodeModel(nodeModel);
        }
        logger.fine("Processing scene " + sceneModel + " DONE");
    }

    private void processNodeModel(NodeModel nodeModel) {
        logger.fine("Processing node " + nodeModel);
        List meshModels = nodeModel.getMeshModels();
        for (MeshModel meshModel : meshModels) {
            List primitives = meshModel.getMeshPrimitiveModels();
            for (int i = 0; i < primitives.size(); ++i) {
                MeshPrimitiveModel meshPrimitiveModel = (MeshPrimitiveModel)primitives.get(i);
                this.processMeshPrimitiveModel(nodeModel, meshModel, meshPrimitiveModel);
            }
        }
        List children = nodeModel.getChildren();
        for (NodeModel childNode : children) {
            this.processNodeModel(childNode);
        }
        logger.fine("Processing node " + nodeModel + " DONE");
    }

    private RenderedMaterial obtainRenderedMaterial(NodeModel nodeModel, MaterialModel materialModel) {
        if (materialModel == null) {
            MaterialModelV1 defaultMaterialModel = (MaterialModelV1)DefaultModels.getDefaultMaterialModel();
            TechniqueModel techniqueModel = defaultMaterialModel.getTechniqueModel();
            Map values = defaultMaterialModel.getValues();
            return new DefaultRenderedMaterial(techniqueModel, values);
        }
        if (materialModel instanceof MaterialModelV1) {
            MaterialModelV1 materialModelV1 = (MaterialModelV1)materialModel;
            TechniqueModel techniqueModel = materialModelV1.getTechniqueModel();
            Map values = materialModelV1.getValues();
            return new DefaultRenderedMaterial(techniqueModel, values);
        }
        if (materialModel instanceof MaterialModelV2) {
            MaterialModelV2 materialModelV2 = (MaterialModelV2)materialModel;
            SkinModel skinModel = nodeModel.getSkinModel();
            int numJoints = 0;
            if (skinModel != null) {
                numJoints = skinModel.getJoints().size();
            }
            return this.materialModelHandler.createRenderedMaterial(materialModelV2, numJoints);
        }
        logger.severe("Unknown material model type: " + materialModel);
        return null;
    }

    private void processMeshPrimitiveModel(NodeModel nodeModel, MeshModel meshModel, MeshPrimitiveModel meshPrimitiveModel) {
        boolean isOpaque;
        logger.fine("Processing meshPrimitive...");
        MaterialModel materialModel = meshPrimitiveModel.getMaterialModel();
        RenderedMaterial renderedMaterial = this.obtainRenderedMaterial(nodeModel, materialModel);
        TechniqueModel techniqueModel = renderedMaterial.getTechniqueModel();
        ProgramModel programModel = techniqueModel.getProgramModel();
        Integer glProgram = this.gltfRenderData.obtainGlProgram(programModel);
        if (glProgram == null) {
            logger.warning("No GL program found for program " + programModel + " in technique " + techniqueModel);
            return;
        }
        int glVertexArray = this.glContext.createGlVertexArray();
        this.gltfRenderData.addGlVertexArray(glVertexArray);
        List<Runnable> attributeUpdateCommands = this.createAttributes(glVertexArray, nodeModel, meshModel, meshPrimitiveModel);
        final ArrayList<Runnable> commands = new ArrayList<Runnable>();
        commands.add(() -> this.glContext.useGlProgram(glProgram));
        List<Runnable> uniformSettingCommands = this.createUniformSettingCommands(renderedMaterial, nodeModel, glProgram);
        commands.addAll(uniformSettingCommands);
        commands.add(() -> this.glContext.disable(TechniqueStatesModel.getAllStates()));
        TechniqueStatesModel techniqueStatesModel = techniqueModel.getTechniqueStatesModel();
        List enabledStates = techniqueStatesModel.getEnable() != null ? techniqueStatesModel.getEnable() : TechniqueStatesModels.createDefaultTechniqueStatesEnable();
        commands.add(() -> this.glContext.enable(enabledStates));
        TechniqueStatesFunctionsModel techniqueStatesFunctionsModel = techniqueStatesModel.getTechniqueStatesFunctionsModel() != null ? techniqueStatesModel.getTechniqueStatesFunctionsModel() : TechniqueStatesModels.createDefaultTechniqueStatesFunctions();
        commands.addAll(TechniqueStatesFunctions.createTechniqueStatesFunctionsSettingCommands(this.glContext, techniqueStatesFunctionsModel));
        commands.addAll(attributeUpdateCommands);
        Runnable renderCommand = this.createRenderCommand(meshPrimitiveModel, glVertexArray);
        commands.add(renderCommand);
        Runnable meshPrimitiveRenderCommand = new Runnable(){

            @Override
            public void run() {
                for (Runnable command : commands) {
                    command.run();
                }
            }

            public String toString() {
                return super.toString();
            }
        };
        boolean bl = isOpaque = !enabledStates.contains(3042);
        if (isOpaque) {
            this.opaqueRenderCommands.add(meshPrimitiveRenderCommand);
        } else {
            this.transparentRenderCommands.add(meshPrimitiveRenderCommand);
        }
        logger.fine("Processing meshPrimitive DONE");
    }

    private Runnable createRenderCommand(MeshPrimitiveModel meshPrimitiveModel, int glVertexArray) {
        int mode = meshPrimitiveModel.getMode();
        AccessorModel indices = meshPrimitiveModel.getIndices();
        if (indices != null) {
            BufferViewModel indicesBufferViewModel = indices.getBufferViewModel();
            Integer glIndicesBufferView = this.gltfRenderData.obtainGlBufferView(indicesBufferViewModel);
            if (glIndicesBufferView == null) {
                logger.warning("No GL bufferView found for indices bufferView " + indicesBufferViewModel);
                return DefaultRenderedGltfModel.emptyRunnable();
            }
            int count = indices.getCount();
            int type = indices.getComponentType();
            int offset = indices.getByteOffset();
            return () -> this.glContext.renderIndexed(glVertexArray, mode, glIndicesBufferView, count, type, offset);
        }
        Map attributes = meshPrimitiveModel.getAttributes();
        if (attributes.isEmpty()) {
            logger.warning("No indices and no attributes found in meshPrimitive");
            return DefaultRenderedGltfModel.emptyRunnable();
        }
        AccessorModel accessorModel = (AccessorModel)attributes.values().iterator().next();
        int count = accessorModel.getCount();
        return () -> this.glContext.renderNonIndexed(glVertexArray, mode, count);
    }

    private List<Runnable> createUniformSettingCommands(RenderedMaterial renderedMaterial, NodeModel nodeModel, Integer glProgram) {
        ArrayList<Runnable> uniformSettingCommands = new ArrayList<Runnable>();
        LinkedHashSet missingTextureUniformNames = new LinkedHashSet();
        TechniqueModel techniqueModel = renderedMaterial.getTechniqueModel();
        Map uniforms = techniqueModel.getUniforms();
        int textureCounter = 0;
        for (String uniformName : uniforms.keySet()) {
            Runnable uniformSettingCommand;
            TechniqueParametersModel techniqueParametersModel = techniqueModel.getUniformParameters(uniformName);
            Supplier<?> uniformValueSupplier = this.uniformGetterFactory.createUniformValueSupplier(uniformName, renderedMaterial, nodeModel);
            int location = this.glContext.getUniformLocation(glProgram, uniformName);
            if (location == -1) {
                logger.warning("No uniform location for uniform " + uniformName);
                continue;
            }
            Integer type = techniqueParametersModel.getType();
            if (type == 35678) {
                int textureIndex = textureCounter++;
                uniformSettingCommand = () -> {
                    if (missingTextureUniformNames.contains(uniformName)) {
                        return;
                    }
                    Object[] value = (Object[])uniformValueSupplier.get();
                    Object textureModelObject = value[0];
                    if (textureModelObject == null || !(textureModelObject instanceof TextureModel)) {
                        logger.warning("No valid texture model found for uniform " + uniformName + ": " + textureModelObject);
                        missingTextureUniformNames.add(uniformName);
                        return;
                    }
                    TextureModel textureModel = (TextureModel)textureModelObject;
                    Integer glTexture = this.gltfRenderData.obtainGlTexture(textureModel);
                    if (glTexture == null) {
                        logger.warning("Could not obtain GL texture for texture " + textureModel);
                    } else {
                        this.glContext.setUniformSampler(location, textureIndex, glTexture);
                    }
                };
                uniformSettingCommands.add(RenderCommandUtils.debugUniformSettingCommand(uniformSettingCommand, uniformName, uniformValueSupplier));
                continue;
            }
            int count = techniqueParametersModel.getCount();
            uniformSettingCommand = this.uniformSetterFactory.createUniformSettingCommand(location, type, count, uniformValueSupplier);
            uniformSettingCommands.add(RenderCommandUtils.debugUniformSettingCommand(uniformSettingCommand, uniformName, uniformValueSupplier));
        }
        return uniformSettingCommands;
    }

    private List<Runnable> createAttributes(int glVertexArray, NodeModel nodeModel, MeshModel meshModel, MeshPrimitiveModel meshPrimitiveModel) {
        ArrayList<Runnable> attributeUpdateCommands = new ArrayList<Runnable>();
        MaterialModel materialModel = meshPrimitiveModel.getMaterialModel();
        RenderedMaterial renderedMaterial = this.obtainRenderedMaterial(nodeModel, materialModel);
        TechniqueModel techniqueModel = renderedMaterial.getTechniqueModel();
        ProgramModel programModel = techniqueModel.getProgramModel();
        Integer glProgram = this.gltfRenderData.obtainGlProgram(programModel);
        if (glProgram == null) {
            logger.warning("No GL program found for program " + programModel + " in technique " + techniqueModel);
            return attributeUpdateCommands;
        }
        Map meshPrimitiveAttributes = meshPrimitiveModel.getAttributes();
        Map attributes = techniqueModel.getAttributes();
        for (String attributeName : attributes.keySet()) {
            int attributeLocation;
            BufferViewModel bufferViewModel;
            Integer glBufferView;
            TechniqueParametersModel attributeTechniqueParametersModel = techniqueModel.getAttributeParameters(attributeName);
            String semantic = attributeTechniqueParametersModel.getSemantic();
            AccessorModel accessorModel = null;
            Morphing.MorphableAttribute morphableAttribute = null;
            if (Morphing.isMorphableAttribute(meshPrimitiveModel, semantic)) {
                morphableAttribute = Morphing.createMorphableAttribute(meshPrimitiveModel, semantic);
                accessorModel = morphableAttribute.getMorphedAccessorModel();
            } else {
                accessorModel = (AccessorModel)meshPrimitiveAttributes.get(semantic);
            }
            if (accessorModel == null) {
                if (semantic.equals("NORMAL")) {
                    logger.info("No normals found, computing default");
                    AccessorModel positionsAccessorModel = (AccessorModel)meshPrimitiveAttributes.get("POSITION");
                    AccessorModel indicesAccessorModel = meshPrimitiveModel.getIndices();
                    accessorModel = NormalComputation.createDefaultNormals(positionsAccessorModel, indicesAccessorModel);
                } else {
                    logger.fine("No accessor model found for semantic " + semantic);
                    continue;
                }
            }
            if ((glBufferView = this.gltfRenderData.obtainGlBufferView(bufferViewModel = accessorModel.getBufferViewModel())) == null) {
                logger.warning("No GL bufferView found for bufferView " + bufferViewModel);
                continue;
            }
            if (morphableAttribute != null) {
                Runnable attributeUpdateCommand = this.createAttributeUpdateCommand(glVertexArray, glBufferView, nodeModel, meshModel, morphableAttribute);
                attributeUpdateCommands.add(attributeUpdateCommand);
            }
            if ((attributeLocation = this.glContext.getAttributeLocation(glProgram, attributeName)) == -1) {
                logger.warning("No attribute location for attribute " + attributeName + " in program " + programModel + ". The attribute name in the shader must match the key of the 'attributes' dictionary.");
            }
            int target = (Integer)Optionals.of((Object)bufferViewModel.getTarget(), (Object)34962);
            int size = accessorModel.getElementType().getNumComponents();
            int type = accessorModel.getComponentType();
            int stride = accessorModel.getByteStride();
            int offset = accessorModel.getByteOffset();
            this.glContext.createVertexAttribute(glVertexArray, target, glBufferView, attributeLocation, size, type, stride, offset);
        }
        return attributeUpdateCommands;
    }

    private Runnable createAttributeUpdateCommand(final int glVertexArray, final int glBufferView, final NodeModel nodeModel, final MeshModel meshModel, final Morphing.MorphableAttribute morphableAttribute) {
        AccessorModel morphedAccessorModel = morphableAttribute.getMorphedAccessorModel();
        BufferViewModel morphedBufferViewModel = morphedAccessorModel.getBufferViewModel();
        morphedBufferViewModel.getByteLength();
        final ByteBuffer morphedBufferViewData = morphedBufferViewModel.getBufferViewData();
        final int bufferSize = morphedBufferViewData.capacity();
        final float[] weights = new float[morphableAttribute.getNumTargets()];
        Runnable attributeUpdateCommand = new Runnable(){

            @Override
            public void run() {
                if (nodeModel.getWeights() != null) {
                    System.arraycopy(nodeModel.getWeights(), 0, weights, 0, weights.length);
                } else if (meshModel.getWeights() != null) {
                    System.arraycopy(meshModel.getWeights(), 0, weights, 0, weights.length);
                }
                morphableAttribute.updateMorphedAccessorData(weights);
                DefaultRenderedGltfModel.this.glContext.updateVertexAttribute(glVertexArray, 34962, glBufferView, 0, bufferSize, morphedBufferViewData);
            }
        };
        return attributeUpdateCommand;
    }

    private static Runnable emptyRunnable() {
        return () -> {};
    }

    private static <T> Map<T, Integer> computeIndexMap(Collection<? extends T> elements) {
        LinkedHashMap<T, Integer> indices = new LinkedHashMap<T, Integer>();
        int index = 0;
        for (T element : elements) {
            indices.put(element, index);
            ++index;
        }
        return indices;
    }
}

