/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.AccessorData;
import de.javagl.jgltf.model.AccessorFloatData;
import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.MeshPrimitiveModel;
import de.javagl.jgltf.viewer.AccessorModelCreation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class Morphing {
    private static final Logger logger = Logger.getLogger(Morphing.class.getName());

    static boolean isMorphableAttribute(MeshPrimitiveModel meshPrimitiveModel, String semantic) {
        Map meshPrimitiveAttributes = meshPrimitiveModel.getAttributes();
        AccessorModel accessorModel = (AccessorModel)meshPrimitiveAttributes.get(semantic);
        if (accessorModel == null) {
            return false;
        }
        boolean hasMorphTargetsForSemantic = false;
        List morphTargets = meshPrimitiveModel.getTargets();
        for (Map morphTarget : morphTargets) {
            AccessorModel targetAccessorModel = (AccessorModel)morphTarget.get(semantic);
            if (targetAccessorModel == null) continue;
            hasMorphTargetsForSemantic = true;
            if (targetAccessorModel.getComponentDataType() == Float.TYPE) continue;
            logger.severe("Morph target accessor for " + semantic + "does not have float component type, but " + targetAccessorModel.getComponentDataType());
            return false;
        }
        if (hasMorphTargetsForSemantic && accessorModel.getComponentDataType() != Float.TYPE) {
            logger.severe("Accessor for " + semantic + " does not have float component type, but " + accessorModel.getComponentDataType());
            return false;
        }
        return hasMorphTargetsForSemantic;
    }

    static MorphableAttribute createMorphableAttribute(MeshPrimitiveModel meshPrimitiveModel, String semantic) {
        Map meshPrimitiveAttributes = meshPrimitiveModel.getAttributes();
        AccessorModel baseAccessorModel = (AccessorModel)meshPrimitiveAttributes.get(semantic);
        ArrayList<AccessorFloatData> targetAccessorFloatDatas = new ArrayList<AccessorFloatData>();
        List morphTargets = meshPrimitiveModel.getTargets();
        for (Map morphTarget : morphTargets) {
            AccessorModel targetAccessorModel = (AccessorModel)morphTarget.get(semantic);
            AccessorData targetAccessorData = targetAccessorModel.getAccessorData();
            AccessorFloatData targetAccessorFloatData = (AccessorFloatData)targetAccessorData;
            targetAccessorFloatDatas.add(targetAccessorFloatData);
        }
        AccessorModel instantiatedAccessorModel = AccessorModelCreation.instantiate(baseAccessorModel, "buffer_for_morphed_attribute_" + semantic + ".bin");
        return new MorphableAttribute(instantiatedAccessorModel, baseAccessorModel, targetAccessorFloatDatas);
    }

    private static void combine3D(AccessorFloatData morphed, AccessorFloatData base, List<? extends AccessorFloatData> targets, float[] weights) {
        int numComponents = 3;
        int numElements = morphed.getNumElements();
        for (int e = 0; e < numElements; ++e) {
            for (int c = 0; c < numComponents; ++c) {
                float r = base.get(e, c);
                for (int i = 0; i < weights.length; ++i) {
                    float w = weights[i];
                    AccessorFloatData target = targets.get(i);
                    float d = target.get(e, c);
                    r += w * d;
                }
                morphed.set(e, c, r);
            }
        }
    }

    private Morphing() {
    }

    static class MorphableAttribute {
        private final AccessorModel morphedAccessorModel;
        private final AccessorModel baseAccessorModel;
        private final List<AccessorFloatData> targetAccessorFloatDatas;

        private MorphableAttribute(AccessorModel morphedAccessorModel, AccessorModel baseAccessorModel, Collection<? extends AccessorFloatData> targetAccessorFloatDatas) {
            this.baseAccessorModel = baseAccessorModel;
            this.morphedAccessorModel = morphedAccessorModel;
            this.targetAccessorFloatDatas = Collections.unmodifiableList(new ArrayList<AccessorFloatData>(targetAccessorFloatDatas));
        }

        AccessorModel getMorphedAccessorModel() {
            return this.morphedAccessorModel;
        }

        int getNumTargets() {
            return this.targetAccessorFloatDatas.size();
        }

        void updateMorphedAccessorData(float[] weights) {
            AccessorFloatData morphedAccessorData = (AccessorFloatData)this.morphedAccessorModel.getAccessorData();
            AccessorFloatData baseAccessorData = (AccessorFloatData)this.baseAccessorModel.getAccessorData();
            Morphing.combine3D(morphedAccessorData, baseAccessorData, this.targetAccessorFloatDatas, weights);
        }
    }
}

