/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.AccessorData;
import de.javagl.jgltf.model.AccessorDatas;
import de.javagl.jgltf.model.AccessorFloatData;
import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.ElementType;
import de.javagl.jgltf.viewer.AccessorDataUtils;
import de.javagl.jgltf.viewer.AccessorModelCreation;

public class NormalComputation {
    static AccessorModel createDefaultNormals(AccessorModel positionsAccessorModel, AccessorModel indicesAccessorModel) {
        int numPositions = positionsAccessorModel.getCount();
        int numTriangles = numPositions / 3;
        int[] indices = null;
        if (indicesAccessorModel != null) {
            AccessorData indicesAccessorData = AccessorDatas.create((AccessorModel)indicesAccessorModel);
            indices = AccessorDataUtils.readInts(indicesAccessorData);
        } else {
            indices = NormalComputation.createDefaultIndices(numTriangles);
        }
        AccessorFloatData positionsAccessorData = AccessorDatas.createFloat((AccessorModel)positionsAccessorModel);
        AccessorModel normalsAccessorModel = AccessorModelCreation.createAccessorModel(5126, numPositions, ElementType.VEC3, "");
        AccessorFloatData normalsAccessorData = AccessorDatas.createFloat((AccessorModel)normalsAccessorModel);
        float[] vertex0 = new float[3];
        float[] vertex1 = new float[3];
        float[] vertex2 = new float[3];
        float[] edge01 = new float[3];
        float[] edge02 = new float[3];
        float[] cross = new float[3];
        float[] normal = new float[3];
        for (int i = 0; i < numTriangles; ++i) {
            int index0 = indices[i * 3 + 0];
            int index1 = indices[i * 3 + 1];
            int index2 = indices[i * 3 + 2];
            NormalComputation.getVector3D(positionsAccessorData, index0, vertex0);
            NormalComputation.getVector3D(positionsAccessorData, index1, vertex1);
            NormalComputation.getVector3D(positionsAccessorData, index2, vertex2);
            NormalComputation.subtract(vertex1, vertex0, edge01);
            NormalComputation.subtract(vertex2, vertex0, edge02);
            NormalComputation.cross(edge01, edge02, cross);
            NormalComputation.normalize(cross, normal);
            NormalComputation.setVector3D(normalsAccessorData, index0, normal);
            NormalComputation.setVector3D(normalsAccessorData, index1, normal);
            NormalComputation.setVector3D(normalsAccessorData, index2, normal);
        }
        return normalsAccessorModel;
    }

    static int[] createDefaultIndices(int numTriangles) {
        int n = numTriangles * 3;
        int[] result = new int[n];
        for (int i = 0; i < n; ++i) {
            result[i] = i;
        }
        return result;
    }

    private static void subtract(float[] a0, float[] a1, float[] result) {
        for (int i = 0; i < a0.length; ++i) {
            result[i] = a0[i] - a1[i];
        }
    }

    private static void cross(float[] a0, float[] a1, float[] result) {
        result[0] = a0[1] * a1[2] - a0[2] * a1[1];
        result[1] = a0[2] * a1[0] - a0[0] * a1[2];
        result[2] = a0[0] * a1[1] - a0[1] * a1[0];
    }

    private static float computeLength(float[] a) {
        float sum = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i] * a[i];
        }
        float r = (float)Math.sqrt(sum);
        return r;
    }

    private static void normalize(float[] a, float[] result) {
        float scaling = 1.0f / NormalComputation.computeLength(a);
        NormalComputation.scale(a, scaling, result);
    }

    private static void scale(float[] a, float factor, float[] result) {
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] * factor;
        }
    }

    private static void getVector3D(AccessorFloatData accessorFloatData, int index, float[] result) {
        result[0] = accessorFloatData.get(index, 0);
        result[1] = accessorFloatData.get(index, 1);
        result[2] = accessorFloatData.get(index, 2);
    }

    private static void setVector3D(AccessorFloatData accessorFloatData, int index, float[] vector) {
        accessorFloatData.set(index, 0, vector[0]);
        accessorFloatData.set(index, 1, vector[1]);
        accessorFloatData.set(index, 2, vector[2]);
    }

    private NormalComputation() {
    }
}

