/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.impl.v1.GlTF;
import de.javagl.jgltf.impl.v1.Program;
import de.javagl.jgltf.impl.v1.Shader;
import de.javagl.jgltf.impl.v1.Technique;
import de.javagl.jgltf.model.io.IO;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

class RenderCommandUtils {
    private static final Logger logger = Logger.getLogger(RenderCommandUtils.class.getName());

    static Runnable debugUniformSettingCommand(final Runnable delegate, final String uniformName, final Supplier<?> uniformValueSupplier) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                Level level = Level.FINE;
                if (logger.isLoggable(level)) {
                    String valueString = RenderCommandUtils.debugString(uniformValueSupplier.get());
                    logger.log(level, "For uniform " + uniformName + " setting " + valueString);
                }
                delegate.run();
            }

            public String toString() {
                String valueString = RenderCommandUtils.debugString(uniformValueSupplier.get());
                return "For uniform " + uniformName + " setting " + valueString;
            }
        };
        return command;
    }

    private static String debugString(Object value) {
        if (value instanceof int[]) {
            return Arrays.toString((int[])value);
        }
        if (value instanceof float[]) {
            float[] array = (float[])value;
            if (array.length % 16 == 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < array.length / 16; ++i) {
                    sb.append("\nMatrix " + i + "\n");
                    sb.append(RenderCommandUtils.createMatrixString(array, i * 16, 4, 4));
                }
                return sb.toString();
            }
            if (array.length % 9 == 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < array.length / 9; ++i) {
                    sb.append("\nMatrix " + i + "\n");
                    sb.append(RenderCommandUtils.createMatrixString(array, i * 9, 3, 3));
                }
                return sb.toString();
            }
            return Arrays.toString(array);
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            return Arrays.toString(array);
        }
        return String.valueOf(value);
    }

    private static String createMatrixString(float[] matrix, int offset, int rows, int columns) {
        String format = "%8.3f";
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int r = 0; r < rows; ++r) {
            if (r > 0) {
                sb.append("\n");
                sb.append(" ");
            }
            for (int c = 0; c < columns; ++c) {
                if (c > 0) {
                    sb.append("  ");
                }
                int index = r + c * rows;
                float value = matrix[offset + index];
                sb.append(String.format(Locale.ENGLISH, format, Float.valueOf(value)));
            }
        }
        sb.append("]");
        return sb.toString();
    }

    static String createInfoString(GlTF gltf, String meshPrimitiveName, String techniqueId, List<?> uniformSettingCommands) {
        StringBuilder sb = new StringBuilder();
        sb.append("RenderCommand for " + meshPrimitiveName + "\n");
        sb.append("    technique: " + techniqueId + "\n");
        Technique technique = (Technique)gltf.getTechniques().get(techniqueId);
        String programId = technique.getProgram();
        Program program = (Program)gltf.getPrograms().get(programId);
        String vertexShaderId = program.getVertexShader();
        String fragmentShaderId = program.getFragmentShader();
        Shader vertexShader = (Shader)gltf.getShaders().get(vertexShaderId);
        Shader fragmentShader = (Shader)gltf.getShaders().get(fragmentShaderId);
        String vertexShaderUriString = vertexShader.getUri();
        String fragmentShaderUriString = fragmentShader.getUri();
        String shaderNames = "";
        shaderNames = IO.isDataUriString((String)vertexShaderUriString) ? shaderNames + "v: (data URI), " : shaderNames + "v: " + vertexShaderUriString + ", ";
        shaderNames = IO.isDataUriString((String)fragmentShaderUriString) ? shaderNames + "f: (data URI)" : shaderNames + "f: " + fragmentShaderUriString;
        sb.append("    program: " + programId + " (" + shaderNames + ")\n");
        sb.append("    uniforms:\n");
        for (Object uniformSettingCommand : uniformSettingCommands) {
            sb.append("        " + uniformSettingCommand + "\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    private RenderCommandUtils() {
    }
}

