/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.CameraModel;
import de.javagl.jgltf.model.GltfAnimations;
import de.javagl.jgltf.model.GltfModel;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.animation.Animation;
import de.javagl.jgltf.model.animation.AnimationManager;
import de.javagl.jgltf.model.animation.AnimationRunner;
import de.javagl.jgltf.viewer.DefaultRenderedCamera;
import de.javagl.jgltf.viewer.DefaultRenderedGltfModel;
import de.javagl.jgltf.viewer.GlContext;
import de.javagl.jgltf.viewer.GltfViewer;
import de.javagl.jgltf.viewer.RenderedCamera;
import de.javagl.jgltf.viewer.RenderedGltfModel;
import de.javagl.jgltf.viewer.ViewConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import java.util.logging.Logger;

public abstract class AbstractGltfViewer<C>
implements GltfViewer<C> {
    private static final Logger logger = Logger.getLogger(AbstractGltfViewer.class.getName());
    private final Supplier<float[]> viewportSupplier = new Supplier<float[]>(){
        private final float[] viewport = new float[4];

        @Override
        public float[] get() {
            this.viewport[0] = 0.0f;
            this.viewport[1] = 0.0f;
            this.viewport[2] = AbstractGltfViewer.this.getWidth();
            this.viewport[3] = AbstractGltfViewer.this.getHeight();
            return this.viewport;
        }
    };
    private final DoubleSupplier aspectRatioSupplier = () -> (double)this.getWidth() / (double)this.getHeight();
    private final ViewConfiguration viewConfiguration = new ViewConfiguration(this.viewportSupplier);
    private final List<Runnable> beforeRenderTasks = Collections.synchronizedList(new ArrayList());
    private final Map<GltfModel, RenderedGltfModel> renderedGltfModels = new LinkedHashMap<GltfModel, RenderedGltfModel>();
    private final Map<GltfModel, List<RenderedCamera>> modelRenderedCameras = new LinkedHashMap<GltfModel, List<RenderedCamera>>();
    private final List<GltfModel> gltfModels = new ArrayList<GltfModel>();
    private final AnimationManager animationManager = GltfAnimations.createAnimationManager((AnimationManager.AnimationPolicy)AnimationManager.AnimationPolicy.LOOP);
    private final AnimationRunner animationRunner;
    private final Map<GltfModel, List<Animation>> modelAnimations;

    protected AbstractGltfViewer() {
        this.animationManager.addAnimationManagerListener(a -> this.triggerRendering());
        this.animationRunner = new AnimationRunner(this.animationManager);
        this.modelAnimations = new LinkedHashMap<GltfModel, List<Animation>>();
        this.setAnimationsRunning(true);
    }

    @Override
    public final void setRenderedCamera(RenderedCamera renderedCamera) {
        this.viewConfiguration.setRenderedCamera(renderedCamera);
        this.triggerRendering();
    }

    @Override
    public final void setAnimationsRunning(boolean running) {
        if (running) {
            this.animationRunner.start();
        } else {
            this.animationRunner.stop();
        }
    }

    @Override
    public abstract C getRenderComponent();

    protected abstract GlContext getGlContext();

    @Override
    public final void addGltfModel(GltfModel gltfModel) {
        Objects.requireNonNull(gltfModel, "The gltfModel may not be null");
        this.gltfModels.add(gltfModel);
        this.addBeforeRenderTask(() -> this.createRenderedGltf(gltfModel));
        this.triggerRendering();
        List<RenderedCamera> renderedCameras = this.createRenderedCameras(gltfModel);
        this.modelRenderedCameras.put(gltfModel, renderedCameras);
        if (this.viewConfiguration.getRenderedCamera() == null && !renderedCameras.isEmpty()) {
            RenderedCamera renderedCamera = renderedCameras.get(0);
            this.viewConfiguration.setRenderedCamera(renderedCamera);
        }
    }

    private void createRenderedGltf(GltfModel gltfModel) {
        logger.info("Creating rendered glTF");
        GlContext glContext = this.getGlContext();
        DefaultRenderedGltfModel renderedGltfModel = new DefaultRenderedGltfModel(glContext, gltfModel, this.viewConfiguration);
        this.renderedGltfModels.put(gltfModel, renderedGltfModel);
        List currentModelAnimations = GltfAnimations.createModelAnimations((Iterable)gltfModel.getAnimationModels());
        this.modelAnimations.put(gltfModel, currentModelAnimations);
        this.animationManager.addAnimations((Iterable)currentModelAnimations);
    }

    @Override
    public void removeGltfModel(GltfModel gltfModel) {
        Objects.requireNonNull(gltfModel, "The gltfModel may not be null");
        this.gltfModels.remove(gltfModel);
        this.modelRenderedCameras.remove(gltfModel);
        this.addBeforeRenderTask(() -> this.deleteRenderedGltfModel(gltfModel));
        List<Animation> currentModelAnimations = this.modelAnimations.get(gltfModel);
        if (currentModelAnimations != null) {
            this.animationManager.removeAnimations(currentModelAnimations);
        }
        this.modelAnimations.remove(gltfModel);
        this.triggerRendering();
    }

    private void deleteRenderedGltfModel(GltfModel gltfModel) {
        RenderedGltfModel renderedGltfModel = this.renderedGltfModels.get(gltfModel);
        if (renderedGltfModel == null) {
            logger.warning("No renderedGltfModel found for gltfModel " + gltfModel);
            return;
        }
        logger.info("Deleting rendered glTF");
        renderedGltfModel.delete();
        this.renderedGltfModels.remove(gltfModel);
    }

    private List<RenderedCamera> createRenderedCameras(GltfModel gltfModel) {
        ArrayList<RenderedCamera> renderedCameras = new ArrayList<RenderedCamera>();
        List nodeModels = gltfModel.getNodeModels();
        List cameraModels = gltfModel.getCameraModels();
        for (int i = 0; i < nodeModels.size(); ++i) {
            NodeModel nodeModel = (NodeModel)nodeModels.get(i);
            CameraModel cameraModel = nodeModel.getCameraModel();
            if (cameraModel == null) continue;
            int cameraIndex = cameraModels.indexOf(cameraModel);
            String nodeName = (String)Optionals.of((Object)nodeModel.getName(), (Object)("node " + i));
            String cameraName = (String)Optionals.of((Object)cameraModel.getName(), (Object)("camera " + cameraIndex));
            String name = cameraName + " at " + nodeName;
            DefaultRenderedCamera renderedCamera = new DefaultRenderedCamera(name, nodeModel, cameraModel, this.aspectRatioSupplier);
            renderedCameras.add(renderedCamera);
        }
        return renderedCameras;
    }

    @Override
    public List<RenderedCamera> getRenderedCameras() {
        ArrayList renderedCameras = new ArrayList();
        for (GltfModel gltfModel : this.gltfModels) {
            renderedCameras.addAll(this.modelRenderedCameras.get(gltfModel));
        }
        return Collections.unmodifiableList(renderedCameras);
    }

    private void addBeforeRenderTask(Runnable beforeRenderTask) {
        this.beforeRenderTasks.add(beforeRenderTask);
    }

    protected final void doRender() {
        this.prepareRender();
        this.beforeRender();
        this.render();
    }

    protected abstract void prepareRender();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeRender() {
        List<Runnable> list = this.beforeRenderTasks;
        synchronized (list) {
            while (this.beforeRenderTasks.size() > 0) {
                Runnable beforeRenderTask = this.beforeRenderTasks.get(0);
                beforeRenderTask.run();
                this.beforeRenderTasks.remove(0);
            }
        }
    }

    protected abstract void render();

    protected final void renderGltfModels() {
        for (RenderedGltfModel renderedGltfModel : this.renderedGltfModels.values()) {
            renderedGltfModel.render();
        }
    }
}

