/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.CameraModel;
import de.javagl.jgltf.model.MathUtils;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.viewer.RenderedCamera;
import java.util.Objects;
import java.util.function.DoubleSupplier;

public class DefaultRenderedCamera
implements RenderedCamera {
    private final NodeModel nodeModel;
    private final CameraModel cameraModel;
    private final float[] viewMatrix;
    private final float[] projectionMatrix;
    private final DoubleSupplier aspectRatioSupplier;
    private final String name;

    DefaultRenderedCamera(String name, NodeModel nodeModel, CameraModel cameraModel, DoubleSupplier aspectRatioSupplier) {
        this.name = name;
        this.nodeModel = Objects.requireNonNull(nodeModel, "The nodeModel may not be null");
        this.cameraModel = Objects.requireNonNull(cameraModel, "The cameraModel may not be null");
        this.aspectRatioSupplier = aspectRatioSupplier;
        this.viewMatrix = new float[16];
        this.projectionMatrix = new float[16];
    }

    @Override
    public float[] getViewMatrix() {
        this.nodeModel.computeGlobalTransform(this.viewMatrix);
        MathUtils.invert4x4((float[])this.viewMatrix, (float[])this.viewMatrix);
        return this.viewMatrix;
    }

    @Override
    public float[] getProjectionMatrix() {
        Float aspectRatio = null;
        if (this.aspectRatioSupplier != null) {
            aspectRatio = Float.valueOf((float)this.aspectRatioSupplier.getAsDouble());
        }
        this.cameraModel.computeProjectionMatrix(this.projectionMatrix, aspectRatio);
        return this.projectionMatrix;
    }

    public String toString() {
        return this.name;
    }
}

